/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 15, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone ( DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.federation.webservices;

import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.exceptions.GlobalArtifactIdentifierFormatException;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.CprsIdentifier;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.InsufficientPatientSensitivityException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.core.interfaces.exceptions.SecurityCredentialsExpiredException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.business.PassthroughInputMethod;
import gov.va.med.imaging.exchange.business.Patient;
import gov.va.med.imaging.exchange.business.PatientSensitiveValue;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.business.vistarad.ActiveExams;
import gov.va.med.imaging.exchange.business.vistarad.Exam;
import gov.va.med.imaging.exchange.business.vistarad.ExamImages;
import gov.va.med.imaging.exchange.business.vistarad.ExamSite;
import gov.va.med.imaging.exchange.business.vistarad.PatientRegistration;
import gov.va.med.imaging.exchange.enums.ImagingSecurityContextType;
import gov.va.med.imaging.exchange.enums.StudyLoadLevel;
import gov.va.med.imaging.exchange.translation.AbstractTranslator;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.federation.FederationRouter;
import gov.va.med.imaging.federation.ImagingFederationContext;
import gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata;
import gov.va.med.imaging.federation.webservices.translation.v3.Translator;
import gov.va.med.imaging.federation.webservices.types.v3.FederationFilterType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationImageAccessLogEventType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationMethodExceptionFaultType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationRemoteMethodParameterType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationSecurityCredentialsExpiredExceptionFaultType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationStudyLoadLevelType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationStudyType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationVistaRadActiveExamsType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationVistaRadExamImagesType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationVistaRadExamType;
import gov.va.med.imaging.federation.webservices.types.v3.FederationVistaRadPatientRegistrationType;
import gov.va.med.imaging.federation.webservices.types.v3.PatientSensitiveCheckResponseType;
import gov.va.med.imaging.federation.webservices.types.v3.PatientType;
import gov.va.med.imaging.federation.webservices.types.v3.RequestorType;
import gov.va.med.imaging.federation.webservices.types.v3.StudiesType;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.webservices.common.WebservicesCommon;

/**
 * @author DNS
 *
 */
public class FederationWebservices_v3 
extends AbstractFederationWebservices
implements ImageFederationMetadata 
{	
	static
	{
		AbstractTranslator.registerTranslatorClass(gov.va.med.imaging.federation.webservices.translation.v3.Translator.class);
	}

	/**
	 * 
	 */
	@Override
	public FederationVistaRadExamType getPatientExam(
		String transactionId,
		String studyUrnString) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType
	{
		setTransactionId(transactionId);
		getLogger().info("getPatientExam for URN '" + studyUrnString + "'.");
		long startTime = System.currentTimeMillis();
		gov.va.med.imaging.federation.webservices.types.v3.FederationVistaRadExamType response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getPatientExams");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn(studyUrnString);
		setVistaRadImagingContext();
		
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			StudyURN studyUrn = URNFactory.create(studyUrnString, SERIALIZATION_FORMAT.PATCH83_VFTP, StudyURN.class);
			transactionContext.setUrn(studyUrn.toString());
			transactionContext.setPatientID(studyUrn.getPatientId());
			Exam exam = router.getExam(studyUrn);
			getLogger().info("getPatientExam, transaction(" + transactionId + ") got " + (exam == null ? "null" : "not null") + " exam business object from router.");
			response = AbstractTranslator.translate(FederationVistaRadExamType.class, exam);
		}
		catch(URNFormatException iurnfX)
		{
			getLogger().error("FAILED getExamImagesForExam transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new FederationMethodExceptionFaultType(iurnfX.getMessage(), null);
		}	
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getPatientExam connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(MethodException cX)
		{
			getLogger().error("FAILED getPatientExam connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			handleMethodException(cX);
			throw new FederationMethodExceptionFaultType(cX.getMessage(), null);
		}		
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, translation exception", ex);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		getLogger().info("complete Federation getPatientExam transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getNextPatientRegistration(java.lang.String, java.lang.String)
	 */
	@Override
	public FederationVistaRadPatientRegistrationType getNextPatientRegistration(
			String transactionId, String siteId) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
		getLogger().info("getNextPatientRegistration at site [" + siteId + "]");
		long startTime = System.currentTimeMillis();
		gov.va.med.imaging.federation.webservices.types.v3.FederationVistaRadPatientRegistrationType response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getNextPatientRegistration");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		setVistaRadImagingContext();
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			PatientRegistration patientRegistration = router.getNextPatientRegistration(routingToken);
			getLogger().info("getNextPatientRegistration, transaction(" + transactionId + ") got " + (patientRegistration == null ? "null" : "not null") + " patient registration business object from router.");
			response = AbstractTranslator.translate(FederationVistaRadPatientRegistrationType.class, patientRegistration);
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getNextPatientRegistration connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(MethodException cX)
		{
			getLogger().error("FAILED getNextPatientRegistration connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			handleMethodException(cX);
			throw new FederationMethodExceptionFaultType(cX.getMessage(), null);
		}		
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, translation exception", ex);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		getLogger().info("complete Federation getNextPatientRegistration transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getRelevantPriorCptCodes(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public String[] getRelevantPriorCptCodes(String transactionId,
			String cptCode, String siteId) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
		getLogger().info("getRelevantPriorCptCodes for cptCode '" + cptCode + "', at site [" + siteId + "]");
		long startTime = System.currentTimeMillis();
		String [] response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getRelevantPriorCptCodes");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		setVistaRadImagingContext();
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			response = router.getRelevantPriorCptCodes(routingToken, cptCode);
			getLogger().info("getRelevantPriorCptCodes, transaction(" + transactionId + ") got " + (response == null ? "null" : response.length) + " CPT Codes from router.");
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getRelevantPriorCptCodes connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(MethodException cX)
		{
			getLogger().error("FAILED getRelevantPriorCptCodes connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			handleMethodException(cX);
			throw new FederationMethodExceptionFaultType(cX.getMessage(), null);
		}		
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		getLogger().info("complete Federation getRelevantPriorCptCodes transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.AbstractFederationWebservices#getWepAppName()
	 */
	@Override
	protected String getWepAppName() 
	{
		return "Federation WebApp V3";
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.AbstractFederationWebservices#transformSitesToSiteNumberArary(java.util.List)
	 */
	@Override
	protected String[] transformSitesToSiteNumberArray(List<ResolvedArtifactSource> sites) 
	throws RemoteException 
	{
		try
		{
			//gov.va.med.imaging.federation.webservices.translation.v3.Translator.translate(sites);
			return AbstractTranslator.translate(String[].class, sites);
		}
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			throw new RemoteException("Internal error, translation exception", ex);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getActiveWorklist(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public FederationVistaRadActiveExamsType getActiveWorklist(String transactionId, String siteId, 
			String listDescriptor)
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
		getLogger().info("getActiveWorklist for list descriptor '" + listDescriptor + ", at site [" + siteId + "]");
		long startTime = System.currentTimeMillis();
		gov.va.med.imaging.federation.webservices.types.v3.FederationVistaRadActiveExamsType response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getActiveWorklist");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		setVistaRadImagingContext();
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			ActiveExams activeExams = router.getActiveWorklist(routingToken, listDescriptor);	
			getLogger().info("getActiveWorklist, transaction(" + transactionId + ") got " + (activeExams == null ? "null" : activeExams.size()) + " ActiveExam business object from router.");
			if(activeExams != null)
				transactionContext.setEntriesReturned(activeExams.size());
			response = AbstractTranslator.translate(FederationVistaRadActiveExamsType.class, activeExams);
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getActiveWorklist connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(MethodException cX)
		{
			getLogger().error("FAILED getActiveWorklist connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			handleMethodException(cX);
			throw new FederationMethodExceptionFaultType(cX.getMessage(), null);
		}		
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, translation exception", ex);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		getLogger().info("complete Federation getActiveWorklist transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getExamImagesForExam(java.lang.String, java.lang.String)
	 */
	@Override
	public FederationVistaRadExamImagesType getExamImagesForExam(
			String transactionId, String studyUrnString) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		
		setTransactionId(transactionId);
		getLogger().info("getExamImagesForExam for study Urn '" + studyUrnString + ".");
		long startTime = System.currentTimeMillis();
		gov.va.med.imaging.federation.webservices.types.v3.FederationVistaRadExamImagesType response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getExamImagesForExam");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn(studyUrnString);
		setVistaRadImagingContext();
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			StudyURN studyUrn = URNFactory.create(studyUrnString, SERIALIZATION_FORMAT.PATCH83_VFTP, StudyURN.class);
			transactionContext.setUrn(studyUrn.toString());
			ExamImages examImages = router.getExamImages(studyUrn);
			getLogger().info("getExamImagesForExam, transaction(" + transactionId + ") got " + (examImages == null ? "null" : examImages.size()) + " ExamImage business object from router.");
			if(examImages != null)
				transactionContext.setEntriesReturned(examImages.size());
			response = AbstractTranslator.translate(FederationVistaRadExamImagesType.class, examImages);
		}
		catch(URNFormatException iurnfX)
		{
			getLogger().error("FAILED getExamImagesForExam transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new FederationMethodExceptionFaultType(iurnfX.getMessage(), null);
		}	
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getExamImagesForExam connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, translation exception", ex);
		}
		catch(MethodException cX)
		{
			getLogger().error("FAILED getExamImagesForExam connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			handleMethodException(cX);
			throw new FederationMethodExceptionFaultType(cX.getMessage(), null);
		}		
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		getLogger().info("complete Federation getExamImagesForExam transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;		
	}
	
	private AbstractImagingURN createAbstractImagingUrnFromBase32EncodedUrn(String urn)
	throws MethodException
	{
		try
		{			
			AbstractImagingURN result = 
				URNFactory.create(urn, SERIALIZATION_FORMAT.PATCH83_VFTP, AbstractImagingURN.class);
			getLogger().info("Converted URN '" + urn + "' to '" + result.toString() + "'.");
			return result;
		}
		catch(URNFormatException urnfX)
		{
			throw new MethodException(urnfX);
		}		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getImageDevFields(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public String getImageDevFields(String imageUrn, String flags,
			String transactionId) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		long startTime = System.currentTimeMillis();
		try
		{				
			AbstractImagingURN urn = createAbstractImagingUrnFromBase32EncodedUrn(imageUrn);
			return getImageDevFieldsInternal(startTime, urn.toString(), flags, transactionId);
		}
		catch(MethodException mX)
		{
			getLogger().info("FAILED getImageDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED getImageDevFields connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getImageInformation(java.lang.String, java.lang.String)
	 */
	@Override
	public String getImageInformation(String imageUrn, String transactionId)
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		long startTime = System.currentTimeMillis();
		try
		{
			AbstractImagingURN urn = createAbstractImagingUrnFromBase32EncodedUrn(imageUrn);
			return getImageInformationInternal(startTime, urn.toString(), transactionId);
		}
		catch(MethodException mX)
		{
			getLogger().info("FAILED getImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED getImageInformation connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getImageSystemGlobalNode(java.lang.String, java.lang.String)
	 */
	@Override
	public String getImageSystemGlobalNode(String imageUrn, String transactionId)
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		long startTime = System.currentTimeMillis();
		try
		{
			AbstractImagingURN urn = createAbstractImagingUrnFromBase32EncodedUrn(imageUrn);
			return getImageSystemGlobalNodeInternal(startTime, urn.toString(), transactionId);
		}
		catch(MethodException mX)
		{
			getLogger().info("FAILED getImageSystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED getImageSystemGlobalNode connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getPatientExams(java.lang.String, java.lang.String, java.lang.String, boolean)
	 */
	@Override
	public FederationVistaRadExamType[] getPatientExams(
		String transactionId,
		String siteId, 
		String patientIcn, 
		boolean fullyLoaded)
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
		getLogger().info("getPatientExams at site [" + siteId + "]");
		long startTime = System.currentTimeMillis();
		gov.va.med.imaging.federation.webservices.types.v3.FederationVistaRadExamType [] response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getPatientExams");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		transactionContext.setPatientID(patientIcn);
		setVistaRadImagingContext();
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			ExamSite examSite = null;
			if(fullyLoaded)
			{
				examSite = router.getFullyLoadedExamSite(routingToken, patientIcn, false, true);	
			}
			else
			{
				examSite = router.getExamSite(routingToken, patientIcn, false, true);
			}
			getLogger().info("getPatientExams, transaction(" + transactionId + ") got " + (examSite == null ? "null" : "not null") + " ExamSite business object from router.");			
			response = AbstractTranslator.translate(FederationVistaRadExamType[].class, examSite);
			transactionContext.setEntriesReturned(response == null ? 0 : response.length);
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getPatientExams connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(MethodException mX)
		{
			getLogger().error("FAILED getPatientExams connection Exception: " + mX.toString(), mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}		
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, translation exception", ex);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		getLogger().info("complete Federation getPatientExams transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getPatientSensitivityLevel(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public PatientSensitiveCheckResponseType getPatientSensitivityLevel(
			String transactionId, String siteId, String patientIcn)
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
		getLogger().info("getPatientSensitivityLevel for patient [" + patientIcn + "] at site [" + siteId + "]");
		long startTime = System.currentTimeMillis();
		gov.va.med.imaging.federation.webservices.types.v3.PatientSensitiveCheckResponseType response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getPatientSensitivityLevel");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		transactionContext.setPatientID(patientIcn);
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			PatientSensitiveValue sensitiveValue =  router.getPatientSensitiveValue(routingToken, patientIcn);
			getLogger().info("getPatientSensitivityLevel, transaction(" + transactionId + ") got " + (sensitiveValue == null ? "null" : "not null") + " PatientSensitiveValue business object from router.");
			response = AbstractTranslator.translate(PatientSensitiveCheckResponseType.class, sensitiveValue);			
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getPatientSensitivityLevel connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(MethodException mX)
		{
			getLogger().error("FAILED getPatientSensitivityLevel connection Exception: " + mX.toString(), mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}		
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, translation exception", ex);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		getLogger().info("complete Federation getPatientSensitivityLevel transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getPatientSitesVisited(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public String[] getPatientSitesVisited(String patientIcn,
			String transactionId, String siteId) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		long startTime = System.currentTimeMillis();
		try
		{	
			return getPatientSitesVisitedInternal(startTime, patientIcn, transactionId, siteId);
		
		}
		catch(MethodException mX)
		{
			getLogger().info("FAILED getPatientSitesVisited method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED getPatientSitesVisited connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getPatientStudyList(gov.va.med.imaging.federation.webservices.types.v3.RequestorType, gov.va.med.imaging.federation.webservices.types.v3.FederationFilterType, java.lang.String, java.lang.String, java.lang.String, java.math.BigInteger, gov.va.med.imaging.federation.webservices.types.v3.FederationStudyLoadLevelType)
	 */
	@Override
	public StudiesType getPatientStudyList(RequestorType requestor,
			FederationFilterType filter, String patientId,
			String transactionId, String siteId,
			BigInteger authorizedSensitivityLevel,
			FederationStudyLoadLevelType studyLoadLevelType)
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
		Long startTime = System.currentTimeMillis();
		getLogger().info("start Federation getPatientStudyList transaction(" + transactionId + ")" );
		StudyFilter studyFilter = null;
		try
		{
			studyFilter = gov.va.med.imaging.federation.webservices.translation.v3.Translator.translate(
					filter, authorizedSensitivityLevel.intValue(), siteId, patientId);
		}
		catch (GlobalArtifactIdentifierFormatException x)
		{
			getLogger().error(x);
			throw new RemoteException(x.getMessage());
		}
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() +  " getPatientStudyList");
		transactionContext.setPatientID(patientId);
		transactionContext.setQueryFilter(TransactionContextFactory.getFilterDateRange(studyFilter.getFromDate(), studyFilter.getToDate()));
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		
		FederationRouter router = ImagingFederationContext.getFederationRouter();
		if(router == null)
			throw new RemoteException("Internal error, unable to retrieve patient studies");
		// not sure about this next line... 4/8/08 jmw
		transactionContext.setSiteNumber(requestor.getFacilityId());
		gov.va.med.imaging.federation.webservices.types.v3.StudiesType result = null;		
		try
		{
			List<Study> studies = null;
			StudyLoadLevel studyLoadLevel = AbstractTranslator.translate(StudyLoadLevel.class, studyLoadLevelType);
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			if(studyLoadLevel == StudyLoadLevel.STUDY_ONLY)
				studies = router.getPatientShallowStudyList(routingToken, 
						PatientIdentifier.icnPatientIdentifier(patientId), studyFilter);
			else if(studyLoadLevel == StudyLoadLevel.STUDY_AND_REPORT)
				studies = router.getPatientShallowStudyWithReportList(routingToken, 
						PatientIdentifier.icnPatientIdentifier(patientId), studyFilter);
			else if(studyLoadLevel == StudyLoadLevel.STUDY_AND_IMAGES)
				studies = router.getPatientStudyWithImagesList(routingToken, 
						PatientIdentifier.icnPatientIdentifier(patientId), studyFilter);
			else			
				studies = router.getPatientStudyList(routingToken, 
						PatientIdentifier.icnPatientIdentifier(patientId), studyFilter);
			transactionContext.setEntriesReturned( studies == null ? 0 : studies.size() );
			getLogger().info("getPatientStudyList, transaction(" + transactionId + ") got " + (studies == null ? "null" : studies.size() ) + " Study business objects from router.");
			result = AbstractTranslator.translate(StudiesType.class, studies);
		}
		catch(InsufficientPatientSensitivityException ipsX)
		{
			getLogger().error("Insufficient patient sensitive value in getPatientShallowStudyList, returning error message to client: " + ipsX.toString(), ipsX );			
			transactionContext.setErrorMessage(ipsX.getMessage());
			transactionContext.setExceptionClassName(ipsX.getClass().getSimpleName());
			try
			{
				result = AbstractTranslator.translate(StudiesType.class, ipsX);
			}
			catch(TranslationException ex)
			{
				getLogger().error("Translation exception: " + ex.getMessage(), ex);
				transactionContext.setErrorMessage(ex.toString());
				transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
				throw new RemoteException("Internal error, translation exception", ex);
			}
		}
		catch(MethodException mX)
		{
			getLogger().error("FAILED getPatientStudyList method Exception: " + mX.toString(), mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getPatientStudyList with Connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			getLogger().error("FAILED getPatientStudyList with Exception: " + rtfX.toString(), rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw createAxisFaultException(rtfX);
		}	
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		
		getLogger().info("complete Federation getPatientStudyList transaction(" + transactionId + ") in " + 
				(System.currentTimeMillis() - startTime) + 	" ms)" );
		return result;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getStudyFromCprsIdentifier(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public FederationStudyType getStudyFromCprsIdentifier(String patientId, String transactionId, 
			String siteId, String cprsIdentifier)
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
		getLogger().info("getStudyFromCprsIdentifier for CprsIdentifier [" + cprsIdentifier + "] at site [" + siteId + "]");
		long startTime = System.currentTimeMillis();
		gov.va.med.imaging.federation.webservices.types.v3.FederationStudyType response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getStudyFromCprsIdentifier");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			List<Study> studies = router.getStudiesByCprsIdentifier(patientId, routingToken, new CprsIdentifier(cprsIdentifier));
			getLogger().info("getStudyFromCprsIdentifier, transaction(" + transactionId + ") got " + (studies == null ? "null" : studies.size() ) + " Study business objects from router.");
			response = Translator.translateToStudy(studies);			
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getStudyFromCprsIdentifier connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(MethodException mX)
		{
			getLogger().error("FAILED getStudyFromCprsIdentifier connection Exception: " + mX.toString(), mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}		
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, translation exception", ex);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		getLogger().info("complete Federation getStudyFromCprsIdentifier transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getVistaRadRadiologyReport(java.lang.String, java.lang.String)
	 */
	@Override
	public String getVistaRadRadiologyReport(String transactionId,
			String studyUrn) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		long startTime = System.currentTimeMillis();
		try
		{			
			StudyURN decodedStudyUrn = URNFactory.create(studyUrn, SERIALIZATION_FORMAT.PATCH83_VFTP, StudyURN.class);
			return getVistaRadRadiologyReportInternal(startTime, transactionId, decodedStudyUrn.toString());
		}
		catch(URNFormatException iurnfX)
		{
			getLogger().error("FAILED getVistaRadRadiologyReport transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new FederationMethodExceptionFaultType(iurnfX.getMessage(), null);
		}	
		catch(MethodException mX)
		{
			getLogger().info("FAILED getVistaRadRadiologyReport method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED getVistaRadRadiologyReport connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);					
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#getVistaRadRequisitionReport(java.lang.String, java.lang.String)
	 */
	@Override
	public String getVistaRadRequisitionReport(String transactionId,
			String studyUrn) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		long startTime = System.currentTimeMillis();
		try
		{			
			StudyURN decodedStudyUrn = URNFactory.create(studyUrn, SERIALIZATION_FORMAT.PATCH83_VFTP, StudyURN.class);
			return getVistaRadRequisitionReportInternal(startTime, transactionId, decodedStudyUrn.toString());
		}
		catch(URNFormatException iurnfX)
		{
			getLogger().error("FAILED getVistaRadRequisitionReport transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new FederationMethodExceptionFaultType(iurnfX.getMessage(), null);
		}	
		catch(MethodException mX)
		{
			getLogger().info("FAILED getVistaRadRequisitionReport method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED getVistaRadRequisitionReport connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#postImageAccessEvent(java.lang.String, gov.va.med.imaging.federation.webservices.types.v3.FederationImageAccessLogEventType)
	 */
	@Override
	public boolean postImageAccessEvent(String transactionId,
			FederationImageAccessLogEventType logEvent) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
    	long startTime = System.currentTimeMillis();
    	TransactionContext transactionContext = TransactionContextFactory.get();

		FederationRouter router = ImagingFederationContext.getFederationRouter();
		if(router == null)
			throw new RemoteException("Internal error, unable to retrieve patient studies");
		
    	getLogger().info("start Federation postImageAccessEvent transaction(" + transactionId + ")" );
    	getLogger().info("logEvent image [" + logEvent.getImageId() + "].");
		try
		{
			ImageAccessLogEvent event = AbstractTranslator.translate(ImageAccessLogEvent.class, logEvent);
			// not sure if this should be here, what if ICN is empty?
			
			transactionContext.setPatientID(event.getPatientIcn());
			transactionContext.setRequestType(getWepAppName() + " postImageAccessEvent [" + logEvent.getEventType() + "]");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			// need to use the Id from the webservice log event since it is the full URN and not just 
			// the individual image identifier
			transactionContext.setUrn(logEvent.getImageId());
			router.logImageAccessEvent(event);
		}
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, translation exception", ex);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		
		getLogger().info("complete Federation postImageAccessEvent transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return true;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#prefetchStudyList(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.federation.webservices.types.v3.FederationFilterType)
	 */
	@Override
	public String prefetchStudyList(String transactionId, String siteId,
			String patientId, FederationFilterType filter)
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#searchPatients(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public PatientType[] searchPatients(String searchCriteria,
			String transactionId, String siteId) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
		long startTime = System.currentTimeMillis();
		getLogger().info("start Federation searchPatients transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		try
		{
			transactionContext.setPatientID("n/a");
			transactionContext.setRequestType(getWepAppName() + " searchPatients");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			FederationRouter router = ImagingFederationContext.getFederationRouter();
			if(router == null)
				throw new RemoteException("Internal error, unable to retrieve patient studies");

			List<Patient> patients = router.getPatientList( searchCriteria, RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId) );
			getLogger().info("searchPatients, transaction(" + transactionId + ") got " + (patients == null ? "null" : patients.size()) + " Patient business objects from router.");
			gov.va.med.imaging.federation.webservices.types.v3.PatientType[] response = 
				AbstractTranslator.translate(gov.va.med.imaging.federation.webservices.types.v3.PatientType[].class, patients);
			transactionContext.setEntriesReturned( response == null ? 0 : response.length );
			getLogger().info("complete Federation searchPatients transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}		
		catch(MethodException mX)
		{
			getLogger().info("FAILED searchPatients method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());	
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED searchPatients connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(TranslationException ex)
		{
			getLogger().error("Translation exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, translation exception", ex);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#remoteMethodPassthrough(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.federation.webservices.types.v3.FederationRemoteMethodParameterType[], java.lang.String)
	 */
	@Override
	public String remoteMethodPassthrough(String transactionId, String siteId,
			String methodName,
			FederationRemoteMethodParameterType[] parameters,
			String imagingContextType) 
	throws RemoteException, FederationMethodExceptionFaultType, FederationSecurityCredentialsExpiredExceptionFaultType 
	{
		setTransactionId(transactionId);
		long startTime = System.currentTimeMillis();
		getLogger().info("start Federation remoteMethodPassthrough method '" + methodName + "', transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		try
		{
			transactionContext.setPatientID("n/a");
			transactionContext.setRequestType(getWepAppName() + " remoteMethodPassthrough method (" + methodName + ")");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			
			ImagingSecurityContextType securityContext = ImagingSecurityContextType.MAG_WINDOWS;
			
			if((imagingContextType != null) && (imagingContextType.length() > 0))
			{
				securityContext = ImagingSecurityContextType.valueOf(imagingContextType);	
			}
			transactionContext.setImagingSecurityContextType(securityContext.toString());
			
			
			FederationRouter router = ImagingFederationContext.getFederationRouter();
			if(router == null)
				throw new RemoteException("Internal error, unable to execute remote Method Passthrough");
			PassthroughInputMethod inputMethod = 
				gov.va.med.imaging.federation.webservices.translation.v3.Translator.translate(methodName, parameters);			
			String result = router.postPassthroughMethod(RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId),  inputMethod);			
			getLogger().info("remoteMethodPassthrough, transaction(" + transactionId + ") got " + (result == null ? "null" : result.length())+ " bytes back from router.");
			transactionContext.setFacadeBytesSent(result == null ? 0L : result.length());
			getLogger().info("complete Federation remoteMethodPassthrough transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return result;
		}		
		catch(MethodException mX)
		{
			getLogger().info("FAILED searchPatients method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());	
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED searchPatients connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v3.ImageFederationMetadata#postVistaRadExamAccessEvent(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public boolean postVistaRadExamAccessEvent(String transactionId,
			String siteId, String inputParameter) 
	throws RemoteException, FederationSecurityCredentialsExpiredExceptionFaultType, FederationMethodExceptionFaultType 
	{
		setTransactionId(transactionId);
		getLogger().info("postVistaRadExamAccessEvent for input '" + inputParameter + "'.");
		long startTime = System.currentTimeMillis();
		boolean response = false;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " postVistaRadExamAccessEvent");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		setVistaRadImagingContext();
		
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			String decodedInputParameter = Translator.translateDecodeExamImageAccessInputParameter(inputParameter);
			getLogger().info("Converted input parameter from '" + inputParameter + "' into '" + decodedInputParameter + "'.");
			response = router.postExamAccessEvent(routingToken, decodedInputParameter);
			getLogger().info("postVistaRadExamAccessEvent, transaction(" + transactionId + ") got " + (response) + " response from logging exam access.");
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED postVistaRadExamAccessEvent connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException(cX.getMessage(), null);
		}
		catch(MethodException mX)
		{
			getLogger().error("FAILED postVistaRadExamAccessEvent connection Exception: " + mX.toString(), mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			handleMethodException(mX);
			throw new FederationMethodExceptionFaultType(mX.getMessage(), null);
		}		
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		getLogger().info("complete Federation postVistaRadExamAccessEvent transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}
	
	private void handleMethodException(MethodException mX)
	throws FederationSecurityCredentialsExpiredExceptionFaultType  
	{
		try
		{
			WebservicesCommon.throwSecurityCredentialsExceptionFromMethodException(mX);
		}
		catch(SecurityCredentialsExpiredException sceX)
		{
			TransactionContextFactory.get().setExceptionClassName(sceX.getClass().getSimpleName());
			throw new FederationSecurityCredentialsExpiredExceptionFaultType(sceX.getMessage(), "");
		}
	}	
}