/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: May 4, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.federation.webservices;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.exceptions.GlobalArtifactIdentifierFormatException;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.CprsIdentifier;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.InsufficientPatientSensitivityException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.business.Patient;
import gov.va.med.imaging.exchange.business.PatientSensitiveValue;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.enums.StudyLoadLevel;
import gov.va.med.imaging.federation.FederationRouter;
import gov.va.med.imaging.federation.ImagingFederationContext;
import gov.va.med.imaging.federation.webservices.translator.FederationWebAppTranslator_v2;
import gov.va.med.imaging.federation.webservices.types.v2.FederationFilterType;
import gov.va.med.imaging.federation.webservices.types.v2.FederationStudyLoadLevelType;
import gov.va.med.imaging.federation.webservices.types.v2.RequestorType;
import gov.va.med.imaging.federation.webservices.types.v2.StudiesType;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.math.BigInteger;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.List;

/**
 * @author vhaiswwerfej
 *
 */
public class FederationWebservices_v2 
extends AbstractFederationWebservices
implements gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata
{
	private FederationWebAppTranslator_v2 federationTranslator = new FederationWebAppTranslator_v2();

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#getImageDevFields(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public String getImageDevFields(String imageUrn, String flags,
			String transactionId) 
	throws RemoteException 
	{
		return getImageDevFieldsInternalHandleExceptions(imageUrn, flags, transactionId);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#getImageInformation(java.lang.String, java.lang.String)
	 */
	@Override
	public String getImageInformation(String imageUrn, String transactionId)
	throws RemoteException 
	{
		return getImageInformationInternalHandleExceptions(imageUrn, transactionId);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#getImageSystemGlobalNode(java.lang.String, java.lang.String)
	 */
	@Override
	public String getImageSystemGlobalNode(String imageUrn, String transactionId)
	throws RemoteException 
	{
		return getImageSystemGlobalNodeInternalHandleExceptions(imageUrn, transactionId);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#getPatientSensitivityLevel(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public gov.va.med.imaging.federation.webservices.types.v2.PatientSensitiveCheckResponseType getPatientSensitivityLevel(
			String transactionId, String siteId, String patientIcn)
	throws RemoteException 
	{
		setTransactionId(transactionId);
		getLogger().info("getPatientSensitivityLevel for patient [" + patientIcn + "] at site [" + siteId + "]");
		long startTime = System.currentTimeMillis();
		gov.va.med.imaging.federation.webservices.types.v2.PatientSensitiveCheckResponseType response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getPatientSensitivityLevel");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		transactionContext.setPatientID(patientIcn);
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			PatientSensitiveValue sensitiveValue =  router.getPatientSensitiveValue(RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId), patientIcn);
			response = federationTranslator.transformPatientSensitiveValue(sensitiveValue);			
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getPatientSensitivityLevel connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch(MethodException cX)
		{
			getLogger().error("FAILED getPatientSensitivityLevel connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			getLogger().error("FAILED getPatientSensitivityLevel connection Exception: " + rtfX.toString() + " ms", rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw createAxisFaultException(rtfX);
		}		
		getLogger().info("complete Federation getPatientSensitivityLevel transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#getPatientSitesVisited(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public String[] getPatientSitesVisited(String patientIcn,
			String transactionId, String siteId) 
	throws RemoteException 
	{
		return getPatientSitesVisitedInternalHandleExceptions(patientIcn, transactionId, siteId);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#getPatientStudyList(gov.va.med.imaging.federation.webservices.types.v2.RequestorType, gov.va.med.imaging.federation.webservices.types.v2.FederationFilterType, java.lang.String, java.lang.String, java.lang.String, java.math.BigInteger, gov.va.med.imaging.federation.webservices.types.v2.FederationStudyLoadLevelType)
	 */
	@Override
	public StudiesType getPatientStudyList(RequestorType requestor,
			FederationFilterType filter, String patientId,
			String transactionId, String siteId,
			BigInteger authorizedSensitivityLevel,
			FederationStudyLoadLevelType studyLoadLevelType) 
	throws RemoteException 
	{
		setTransactionId(transactionId);
		Long startTime = System.currentTimeMillis();
		getLogger().info("start Federation getPatientStudyList transaction(" + transactionId + ")" );
		StudyFilter studyFilter = null;
		try
		{
			studyFilter = federationTranslator.transformFilter(filter, authorizedSensitivityLevel.intValue());
		}
		catch (GlobalArtifactIdentifierFormatException x)
		{
			getLogger().error(x);
			throw new RemoteException(x.getMessage());
		}
		StudyLoadLevel studyLoadLevel = federationTranslator.transformStudyLoadLevel(studyLoadLevelType);
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() +  " getPatientStudyList");
		transactionContext.setPatientID(patientId);
		transactionContext.setQueryFilter(TransactionContextFactory.getFilterDateRange(studyFilter.getFromDate(), studyFilter.getToDate()));
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		
		FederationRouter router = ImagingFederationContext.getFederationRouter();
		if(router == null)
			throw new RemoteException("Internal error, unable to retrieve patient studies");
		// not sure about this next line... 4/8/08 jmw
		transactionContext.setSiteNumber(requestor.getFacilityId());
		gov.va.med.imaging.federation.webservices.types.v2.StudiesType result = null;		
		try
		{
			List<Study> studies = null;
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			
			if(studyLoadLevel == StudyLoadLevel.STUDY_ONLY)
				studies = router.getPatientShallowStudyList(routingToken, 
						PatientIdentifier.icnPatientIdentifier(patientId), studyFilter);
			else if(studyLoadLevel == StudyLoadLevel.STUDY_AND_REPORT)
				studies = router.getPatientShallowStudyWithReportList(routingToken, 
						PatientIdentifier.icnPatientIdentifier(patientId), studyFilter);
			else			
				studies = router.getPatientStudyList(routingToken,
						PatientIdentifier.icnPatientIdentifier(patientId), studyFilter);
			transactionContext.setEntriesReturned( studies == null ? 0 : studies.size() );
			getLogger().info("Received [" + (studies == null ? "0" : studies.size()) + "] studies from router");			
			result = federationTranslator.transformStudiesToResponse(studies);
		}
		catch(InsufficientPatientSensitivityException ipsX)
		{
			getLogger().error("Insufficient patient sensitive value in getPatientShallowStudyList, returning error message to client: " + ipsX.toString(), ipsX );			
			transactionContext.setErrorMessage(ipsX.getMessage());
			transactionContext.setExceptionClassName(ipsX.getClass().getSimpleName());
			result = federationTranslator.transformExceptionToShallowStudiesType(ipsX);
		}
		catch(MethodException mX)
		{
			getLogger().error("FAILED getPatientStudyList method Exception: " + mX.toString() + " ms", mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw createAxisFaultException(mX);
		}
		catch(ParseException pX)
		{
			getLogger().error("FAILED getPatientStudyList transaction(" + transactionId, pX );
			transactionContext.setErrorMessage(pX.getMessage());
			transactionContext.setExceptionClassName(pX.getClass().getSimpleName());
			throw createAxisFaultException(pX);
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getPatientStudyList with Connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			getLogger().error("FAILED getPatientStudyList with Connection Exception: " + rtfX.toString(), rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw createAxisFaultException(rtfX);
		}	
		
		getLogger().info("complete Federation getPatientStudyList transaction(" + transactionId + ") in " + 
				(System.currentTimeMillis() - startTime) + 	" ms)" );
		return result;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#postImageAccessEvent(java.lang.String, gov.va.med.imaging.federation.webservices.types.v2.FederationImageAccessLogEventType)
	 */
	@Override
	public boolean postImageAccessEvent(String transactionId,
			gov.va.med.imaging.federation.webservices.types.v2.FederationImageAccessLogEventType logEvent) 
	throws RemoteException 
	{
		setTransactionId(transactionId);
    	long startTime = System.currentTimeMillis();
    	TransactionContext transactionContext = TransactionContextFactory.get();

		FederationRouter router = ImagingFederationContext.getFederationRouter();
		if(router == null)
			throw new RemoteException("Internal error, unable to retrieve patient studies");
		
    	getLogger().info("start Federation postImageAccessEvent transaction(" + transactionId + ")" );
    	getLogger().info("logEvent image [" + logEvent.getImageId() + "].");
		try
		{
			ImageAccessLogEvent event = federationTranslator.transformLogEvent(logEvent);
			// not sure if this should be here, what if ICN is empty?
			
			transactionContext.setPatientID(event.getPatientIcn());
			transactionContext.setRequestType(getWepAppName() + " postImageAccessEvent [" + logEvent.getEventType() + "]");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			// need to use the Id from the webservice log event since it is the full URN and not just 
			// the individual image identifier
			transactionContext.setUrn(logEvent.getImageId());
			router.logImageAccessEvent(event);
		}
		catch(MethodException mX)
		{
			getLogger().info("FAILED postImageAccessEvent method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());			
			throw createAxisFaultException(mX);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED postImageAccessEvent connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch(URNFormatException iurnfX) {
			transactionContext.setErrorMessage(iurnfX.getMessage());
			getLogger().info("FAIlED postImageAccessEvent transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			throw createAxisFaultException(iurnfX);
		}
		
		getLogger().info("complete Federation postImageAccessEvent transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return true;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#prefetchStudyList(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.federation.webservices.types.v2.FederationFilterType)
	 */
	@Override
	public String prefetchStudyList(String transactionId, String siteId, String patientId, 
			gov.va.med.imaging.federation.webservices.types.v2.FederationFilterType filter)
			throws RemoteException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#searchPatients(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public gov.va.med.imaging.federation.webservices.types.v2.PatientType[] searchPatients(
			String searchCriteria, String transactionId, String siteId) 
	throws RemoteException 
	{
		setTransactionId(transactionId);
		long startTime = System.currentTimeMillis();
		getLogger().info("start Federation searchPatients transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		try{
			transactionContext.setPatientID("n/a");
			transactionContext.setRequestType(getWepAppName() + " searchPatients");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			FederationRouter router = ImagingFederationContext.getFederationRouter();
			if(router == null)
				throw new RemoteException("Internal error, unable to retrieve patient studies");

			List<Patient> patients = router.getPatientList(searchCriteria, RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId));
			gov.va.med.imaging.federation.webservices.types.v2.PatientType[] response = 
				federationTranslator.transformPatients(patients);
			transactionContext.setEntriesReturned( response == null ? 0 : response.length );
			getLogger().info("complete Federation searchPatients transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}		
		catch(MethodException mX)
		{
			getLogger().info("FAILED searchPatients method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());			
			throw createAxisFaultException(mX);
		}
		catch(ConnectionException cX)
		{
			getLogger().info("FAILED searchPatients connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			getLogger().error("FAILED getPatientStudyList with Connection Exception: " + rtfX.toString(), rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw createAxisFaultException(rtfX);
		}	
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.v2.ImageFederationMetadata#getStudyFromCprsIdentifier(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public gov.va.med.imaging.federation.webservices.types.v2.FederationStudyType getStudyFromCprsIdentifier(
			String patientId, String transactionId, String siteId, String cprsIdentifier)
	throws RemoteException 
	{
		setTransactionId(transactionId);
		getLogger().info("getStudyFromCprsIdentifier for CprsIdentifier [" + cprsIdentifier + "] at site [" + siteId + "]");
		long startTime = System.currentTimeMillis();
		gov.va.med.imaging.federation.webservices.types.v2.FederationStudyType response = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getStudyFromCprsIdentifier");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		FederationRouter router = ImagingFederationContext.getFederationRouter(); 
		try
		{
			List<Study> studies = router.getStudiesByCprsIdentifier(patientId, 
					RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId), new CprsIdentifier(cprsIdentifier));			
			response = federationTranslator.transformStudiesToStudy(studies);			
		}
		catch(ParseException pX)
		{
			getLogger().error("FAILED getStudyFromCprsIdentifier transaction(" + transactionId, pX );
			transactionContext.setErrorMessage(pX.getMessage());
			throw createAxisFaultException(pX);
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED getStudyFromCprsIdentifier connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch(MethodException cX)
		{
			getLogger().error("FAILED getStudyFromCprsIdentifier connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			getLogger().error("FAILED getStudyFromCprsIdentifier connection Exception: " + rtfX.toString() + " ms", rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw createAxisFaultException(rtfX);
		}		
		getLogger().info("complete Federation getStudyFromCprsIdentifier transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.AbstractFederationWebservices#getWepAppName()
	 */
	@Override
	protected String getWepAppName() 
	{
		return "Federation WebApp V2";
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.AbstractFederationWebservices#transformSitesToSiteNumberArary(java.util.List)
	 */
	@Override
	protected String[] transformSitesToSiteNumberArray(List<ResolvedArtifactSource> sites) 
	{
		return federationTranslator.transformSitesToSiteNumberArary(sites);
	}	
}
