/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: May 4, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.federation.webservices;

import gov.va.med.PatientIdentifier;
import gov.va.med.URNFactory;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.ImageNotFoundException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.core.interfaces.exceptions.PatientNotFoundException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.enums.ImagingSecurityContextType;
import gov.va.med.imaging.federation.FederationRouter;
import gov.va.med.imaging.federation.ImagingFederationContext;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

/**
 * @author DNS
 *
 */
public abstract class AbstractFederationWebservices 
{
	protected abstract String getWepAppName();
	
	protected abstract String[] transformSitesToSiteNumberArray(List<ResolvedArtifactSource> sites) 
	throws RemoteException;
	
	
	private Logger logger = Logger.getLogger(AbstractFederationWebservices.class);
	
	protected Logger getLogger()
	{
		return logger;
	}
	
	protected void setTransactionId(String transactionId)
	{
		logger.info(
				"setTransactionContext, id='" + transactionId + 
				"'.");
		TransactionContext transactionContext = TransactionContextFactory.get();		
		if(transactionId != null)
			transactionContext.setTransactionId(transactionId);
		
	}
	
	protected String getVistaRadRequisitionReportInternal(long startTime, String transactionId,
			String studyUrnString)
	throws ConnectionException, MethodException, URNFormatException
	{
		setTransactionId(transactionId);		
		logger.info("start Federation getVistaRadRequisitionReport transaction(" + transactionId + ")" );		
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		StudyURN studyUrn = URNFactory.create(studyUrnString, StudyURN.class);
		transactionContext.setPatientID(studyUrn.getPatientId());
		transactionContext.setRequestType(getWepAppName() + " getVistaRadRadiologyReport");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		setVistaRadImagingContext();
		FederationRouter router = ImagingFederationContext.getFederationRouter();
		if(router == null)
			throw new ConnectionException("Internal error, unable to retrieve VistARad requisition report");
		
		String response = router.getExamRequisitionReport(studyUrn);
		transactionContext.setFacadeBytesSent(response == null ? 0L : response.length());
		logger.info("complete Federation getVistaRadRequisitionReport transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}
	
	protected String getVistaRadRadiologyReportInternal(long startTime, String transactionId,
		String studyUrnString)
	throws ConnectionException, MethodException, URNFormatException
	{
		setTransactionId(transactionId);		
		logger.info("start Federation getVistaRadRadiologyReport transaction(" + transactionId + ")" );		
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		StudyURN studyUrn = URNFactory.create(studyUrnString, StudyURN.class);
		transactionContext.setPatientID(studyUrn.getPatientId());
		transactionContext.setRequestType(getWepAppName() + " getVistaRadRadiologyReport");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		setVistaRadImagingContext();
		FederationRouter router = ImagingFederationContext.getFederationRouter();
		if(router == null)
			throw new ConnectionException("Internal error, unable to retrieve VistARad radiology report");
		
		String response = router.getExamReport(studyUrn);
		transactionContext.setFacadeBytesSent(response == null ? 0L : response.length());
		logger.info("complete Federation getVistaRadRadiologyReport transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return response;
	}
	
	protected String[] getPatientSitesVisitedInternalHandleExceptions(String patientIcn, String transactionId, 
			String siteId) 
	throws RemoteException
	{
		long startTime = System.currentTimeMillis();		
		TransactionContext transactionContext = TransactionContextFactory.get();		
		try
		{
			return getPatientSitesVisitedInternal(startTime, patientIcn, transactionId, siteId);
		}		
		catch(MethodException mX)
		{
			logger.info("FAILED getPatientSitesVisited method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw createAxisFaultException(mX);
		}
		catch(ConnectionException cX)
		{
			logger.info("FAILED getPatientSitesVisited connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw createAxisFaultException(ex);
		}
	}
	
	protected String[] getPatientSitesVisitedInternal(long startTime, String patientIcn, String transactionId, 
			String siteId) 
	throws ConnectionException, MethodException 
	{
		setTransactionId(transactionId);
		logger.info("start Federation getPatientSitesVisited transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		try
		{
			transactionContext.setPatientID(patientIcn);
			transactionContext.setRequestType(getWepAppName() + " getPatientSitesVisited");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			FederationRouter router = ImagingFederationContext.getFederationRouter();
			if(router == null)
				throw new RemoteException("Internal error, unable to retrieve patient studies");
			
			List<ResolvedArtifactSource> sites = null;
			try
			{
				sites = router.getTreatingSites(RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId), 
						PatientIdentifier.icnPatientIdentifier(patientIcn));
			}
			catch(PatientNotFoundException pnfX)
			{
				// this version of federation expects an array of empty sites t obe returned rather than an exception
				sites = new ArrayList<ResolvedArtifactSource>(0);
			}
			String[] response = transformSitesToSiteNumberArray(sites);
			transactionContext.setEntriesReturned( response == null ? 0 : response.length );
			logger.info("complete Federation getPatientSitesVisited transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}		
		catch(ClassCastException ccX)
		{
			// logging and transaction context setting handled by calling method
			throw new MethodException(ccX);
		}
		catch(ImageNotFoundException infX)
		{
			// logging and transaction context setting handled by calling method
			throw new MethodException(infX);
		}
		catch(IOException ioX)
		{
			// logging and transaction context setting handled by calling method
			throw new ConnectionException(ioX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			throw new ConnectionException(rtfX);
		}	
	}
	
	protected String getImageSystemGlobalNodeInternal(long startTime, String imageUrn, String transactionId)
	throws MethodException, ConnectionException
	{
		setTransactionId(transactionId);
		logger.info("start Federation getImageSystemGlobalNode transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		AbstractImagingURN urn = null;
		try
		{
			urn = URNFactory.create(imageUrn, AbstractImagingURN.class);
			transactionContext.setPatientID(urn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageSystemGlobalNode");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(imageUrn);
			FederationRouter router = ImagingFederationContext.getFederationRouter();
			if(router == null)
				throw new RemoteException("Internal error, unable to retrieve patient studies");
			
			String response = router.getImageSystemGlobalNode(urn);
			transactionContext.setFacadeBytesSent(response == null ? 0L : response.length());
			logger.info("complete Federation getImageSystemGlobalNode transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch(ClassCastException ccX)
		{
			// logging and transaction context setting handled by calling method
			throw new MethodException(ccX);
		}
		catch(URNFormatException iurnfX)
		{
			// logging and transaction context setting handled by calling method
			throw new MethodException(iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			// logging and transaction context setting handled by calling method
			throw new MethodException(infX);
		}
		catch(IOException ioX)
		{
			// logging and transaction context setting handled by calling method
			throw new ConnectionException(ioX);
		}		
	}
	
	protected String getImageSystemGlobalNodeInternalHandleExceptions(String imageUrn, String transactionId)
	throws RemoteException 
	{
		long startTime = System.currentTimeMillis();		
		TransactionContext transactionContext = TransactionContextFactory.get();		
		try
		{
			return getImageSystemGlobalNodeInternal(startTime, imageUrn, transactionId);
		}		
		catch(MethodException mX)
		{
			logger.info("FAILED getImageSystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw createAxisFaultException(mX);
		}
		catch(ConnectionException cX)
		{
			logger.info("FAILED getImageSusyemGlobalNode connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw createAxisFaultException(ex);
		}
	}
	
	protected String getImageInformationInternalHandleExceptions(String imageUrn, String transactionId)
	throws RemoteException 
	{		
		long startTime = System.currentTimeMillis();				
		TransactionContext transactionContext = TransactionContextFactory.get();		
		try
		{
			return getImageInformationInternal(startTime, imageUrn, transactionId);
		}		
		catch(MethodException mX)
		{
			logger.info("FAILED getImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw createAxisFaultException(mX);
		}
		catch(ConnectionException cX)
		{
			logger.info("FAILED getImageInformation connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw createAxisFaultException(ex);
		}
	}
	
	protected String getImageInformationInternal(long startTime, String imageUrn, String transactionId)
	throws MethodException, ConnectionException 
	{
		setTransactionId(transactionId);
		logger.info("start Federation getImageInformation transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		AbstractImagingURN urn = null;
		try
		{
			urn = URNFactory.create(imageUrn, AbstractImagingURN.class);
			transactionContext.setPatientID(urn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageInformation");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(urn.toString());
			FederationRouter router = ImagingFederationContext.getFederationRouter();
			if(router == null)
				throw new RemoteException("Internal error, unable to retrieve patient studies");
			
			String response = router.getImageInformation(urn);
			transactionContext.setFacadeBytesSent(response == null ? 0L : response.length());
			logger.info("complete Federation getImageInformation transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch(ClassCastException ccX)
		{
			// logging and transaction context setting handled by calling method
			throw new MethodException(ccX);
		}
		catch(URNFormatException iurnfX)
		{
			// logging and transaction context setting handled by calling method
			throw new MethodException(iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			// logging and transaction context setting handled by calling method
			throw infX;
		}
		catch(IOException ioX)
		{
			// logging and transaction context setting handled by calling method
			throw new ConnectionException(ioX);
		}		
	}
	
	protected String getImageDevFieldsInternalHandleExceptions(String imageUrn, String flags,
		String transactionId) 
	throws RemoteException 
	{
		long startTime = System.currentTimeMillis();
		TransactionContext transactionContext = TransactionContextFactory.get();
		try
		{
			return getImageDevFieldsInternal(startTime, imageUrn, flags, transactionId);
		}		
		catch(MethodException mX)
		{
			logger.info("FAILED getImageDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw createAxisFaultException(mX);
		}
		catch(ConnectionException cX)
		{
			logger.info("FAILED getImageDevFields connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw createAxisFaultException(cX);
		}
		catch(Exception ex)
		{
			getLogger().error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw createAxisFaultException(ex);
		}
	}
	
	protected String getImageDevFieldsInternal(long startTime, String imageUrn, String flags,
			String transactionId) 
	throws MethodException, ConnectionException
	{
		setTransactionId(transactionId);
		logger.info("start Federation getImageDevFields transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		AbstractImagingURN urn = null;
		try
		{
			urn = URNFactory.create(imageUrn, AbstractImagingURN.class);
			transactionContext.setPatientID(urn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageDevFields");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(imageUrn);
			FederationRouter router = ImagingFederationContext.getFederationRouter();
			if(router == null)
				throw new RemoteException("Internal error, unable to retrieve patient studies");
			
			String response = router.getImageDevFields(urn, flags);
			transactionContext.setFacadeBytesSent(response == null ? 0L : response.length());
			logger.info("complete Federation getImageDevFields transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch(ClassCastException ccX)
		{
			// logging and transaction context setting handled by calling method
			throw new MethodException(ccX);
		}
		catch(URNFormatException iurnfX)
		{
			// logging and transaction context setting handled by calling method
			throw new MethodException(iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			// logging and transaction context setting handled by calling method
			throw infX;
		}
		catch(IOException ioX)
		{
			// logging and transaction context setting handled by calling method
			throw new ConnectionException(ioX);
		}		
	}
	
	protected AxisFault createAxisFaultException(Exception ex)
	{
		AxisFault af = new AxisFault(ex.getMessage());
		//AxisFault af = AxisFault.makeFault(ex);
		af.setFaultCodeAsString(ex.getClass().getName());
		return af;
	}
		
	protected void setVistaRadImagingContext()
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setImagingSecurityContextType(ImagingSecurityContextType.MAGJ_VISTARAD.toString());
	}
}
