/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 21, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.federation.commands.externalsystemoperation;

import java.util.HashMap;
import java.util.Map;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.exceptions.GlobalArtifactIdentifierFormatException;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.enums.StudyLoadLevel;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.federation.FederationRouter;
import gov.va.med.imaging.federation.commands.AbstractFederationCommand;
import gov.va.med.imaging.federation.rest.translator.FederationRestTranslator;
import gov.va.med.imaging.federation.rest.types.FederationFilterType;
import gov.va.med.imaging.federation.rest.types.FederationStudyLoadLevelType;
import gov.va.med.imaging.rest.types.RestBooleanReturnType;
import gov.va.med.imaging.rest.types.RestCoreTranslator;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

/**
 * @author vhaiswwerfej
 *
 */
public class FederationExternalSystemOperationPrefetchStudiesCommand
extends AbstractFederationCommand<Boolean, RestBooleanReturnType>
{
	
	private final String routingTokenString;	
	private final String patientIcn;
	private final int authorizedSensitivityLevel;
	private final FederationStudyLoadLevelType studyLoadLevelType;
	private final FederationFilterType federationFilterType;
	private final String interfaceVersion;
	
	public FederationExternalSystemOperationPrefetchStudiesCommand(String routingTokenString, String patientIcn, 
			int authorizedSensitivityLevel, FederationStudyLoadLevelType studyLoadLevelType,
			FederationFilterType federationFilterType,
			String interfaceVersion)
	{
		super("prefetchPatientStudies");
		this.routingTokenString = routingTokenString;
		this.patientIcn = patientIcn;
		this.authorizedSensitivityLevel = authorizedSensitivityLevel;
		this.studyLoadLevelType = studyLoadLevelType;
		this.federationFilterType = federationFilterType;
		this.interfaceVersion = interfaceVersion;
	}

	public String getRoutingTokenString()
	{
		return routingTokenString;
	}

	public String getPatientIcn()
	{
		return patientIcn;
	}

	public int getAuthorizedSensitivityLevel()
	{
		return authorizedSensitivityLevel;
	}

	public FederationStudyLoadLevelType getStudyLoadLevelType()
	{
		return studyLoadLevelType;
	}

	public FederationFilterType getFederationFilterType()
	{
		return federationFilterType;
	}

	@Override
	protected Boolean executeRouterCommand() 
	throws MethodException, ConnectionException
	{
		StudyFilter studyFilter = null;
		try
		{
			studyFilter = FederationRestTranslator.translate(getFederationFilterType(), 
					getAuthorizedSensitivityLevel(), true);
		}
		catch (GlobalArtifactIdentifierFormatException x)
		{
			getLogger().error(x);
			// must throw new instance of exception or else Jersey translates it to a 500 error
			throw new ConnectionException(x.getMessage());
		}
		TransactionContext transactionContext = TransactionContextFactory.get();		
		transactionContext.setQueryFilter(TransactionContextFactory.getFilterDateRange(studyFilter.getFromDate(), 
				studyFilter.getToDate()));
		
		try
		{
			FederationRouter router = getRouter();
			StudyLoadLevel studyLoadLevel = FederationRestTranslator.translate(studyLoadLevelType);
			RoutingToken routingToken = FederationRestTranslator.translateRoutingToken(getRoutingTokenString());
			return router.prefetchPatientStudies(routingToken, 
					PatientIdentifier.icnPatientIdentifier(getPatientIcn()), studyFilter, studyLoadLevel);
		}
		catch(RoutingTokenFormatException rtfX)
		{
			// must throw new instance of exception or else Jersey translates it to a 500 error
			throw new ConnectionException(rtfX);
		}
	}

	@Override
	public Integer getEntriesReturned(RestBooleanReturnType translatedResult)
	{
		return 0;
	}

	@Override
	public String getInterfaceVersion()
	{
		return this.interfaceVersion;
	}

	@Override
	protected String getMethodParameterValuesString()
	{
		return "patient '" + getPatientIcn() + "' from site '" + getRoutingTokenString() + "' with load level '" + FederationRestTranslator.translate(getStudyLoadLevelType()) + "'.";
	}

	@Override
	protected Class<RestBooleanReturnType> getResultClass()
	{
		return RestBooleanReturnType.class;
	}

	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		Map<WebserviceInputParameterTransactionContextField, String> transactionContextFields = 
			new HashMap<WebserviceInputParameterTransactionContextField, String>();
		
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.quality, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.urn, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.patientId, getPatientIcn());

		return transactionContextFields;
	}

	@Override
	public void setAdditionalTransactionContextFields()
	{
		
	}

	@Override
	protected RestBooleanReturnType translateRouterResult(Boolean routerResult)
	throws TranslationException, MethodException
	{		
		return RestCoreTranslator.translate(routerResult);
	}

}
