/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.federation;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class FederationRouterTest
 //extends  gov.va.med.imaging.ImagingBaseWebFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public FederationRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientSensitiveValue(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientSensitivityLevelCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.PatientSensitiveValue.class, 
	 				"GetPatientSensitivityLevelCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientSensitivityLevelCommand' in method 'getPatientSensitiveValue' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudiesByCprsIdentifier(
 			java.lang.String patientIcn
 		 			, gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.CprsIdentifier cprsIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudiesByCprsIdentifierCommand' and parameters 'java.lang.String, gov.va.med.RoutingToken, gov.va.med.imaging.CprsIdentifier'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetStudiesByCprsIdentifierCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, gov.va.med.RoutingToken.class, gov.va.med.imaging.CprsIdentifier.class 
	  			},
				new Object[]{
			 		patientIcn,routingToken,cprsIdentifier
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudiesByCprsIdentifierCommand' in method 'getStudiesByCprsIdentifier' with parameters 'java.lang.String, gov.va.med.RoutingToken, gov.va.med.imaging.CprsIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getNextPatientRegistration(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientRegistrationCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.PatientRegistration.class, 
	 				"GetPatientRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientRegistrationCommand' in method 'getNextPatientRegistration' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getRelevantPriorCptCodes(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String cptCode
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetRelevantPriorCptCodesCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String[].class, 
	 				"GetRelevantPriorCptCodesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,cptCode
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetRelevantPriorCptCodesCommand' in method 'getRelevantPriorCptCodes' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getActiveWorklist(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String listDescriptor
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetActiveWorklistCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.ActiveExams.class, 
	 				"GetActiveWorklistCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,listDescriptor
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetActiveWorklistCommand' in method 'getActiveWorklist' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExam(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.Exam.class, 
	 				"GetExamCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamCommand' in method 'getExam' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamSite(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, java.lang.Boolean forceRefresh
 		 			, java.lang.Boolean forceImagesFromJb
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamSiteBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean, java.lang.Boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.ExamSite.class, 
	 				"GetExamSiteBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.Boolean.class, java.lang.Boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn,forceRefresh,forceImagesFromJb
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamSiteBySiteNumberCommand' in method 'getExamSite' with parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean, java.lang.Boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getFullyLoadedExamSite(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, boolean forceRefresh
 		 			, boolean forceImagesFromJb
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetFullyLoadedExamSiteBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.ExamSite.class, 
	 				"GetFullyLoadedExamSiteBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn,forceRefresh,forceImagesFromJb
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetFullyLoadedExamSiteBySiteNumberCommand' in method 'getFullyLoadedExamSite' with parameters 'gov.va.med.RoutingToken, java.lang.String, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamReport(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamReportCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetExamReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamReportCommand' in method 'getExamReport' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamRequisitionReport(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamRequisitionReportCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetExamRequisitionReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamRequisitionReportCommand' in method 'getExamRequisitionReport' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamImages(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamImagesByStudyUrnCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.ExamImages.class, 
	 				"GetExamImagesByStudyUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamImagesByStudyUrnCommand' in method 'getExamImages' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postExamAccessEvent(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String inputParameter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostExamAccessEventCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostExamAccessEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,inputParameter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostExamAccessEventCommand' in method 'postExamAccessEvent' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchExamImages(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PrefetchExamImagesCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PrefetchExamImagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PrefetchExamImagesCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void refreshSiteServiceCache(
 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessSiteServiceCacheRefreshCommand' and parameters ''.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"ProcessSiteServiceCacheRefreshCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessSiteServiceCacheRefreshCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getFullyLoadedPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetFullyLoadedArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetFullyLoadedArtifactResultsBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetFullyLoadedArtifactResultsBySiteNumberCommand' in method 'getFullyLoadedPatientArtifactResultsFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyOnlyPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyOnlyArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyOnlyArtifactResultsBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyOnlyArtifactResultsBySiteNumberCommand' in method 'getStudyOnlyPatientArtifactResultsFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyWithImagesPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyWithImagesArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyWithImagesArtifactResultsBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyWithImagesArtifactResultsBySiteNumberCommand' in method 'getStudyWithImagesPatientArtifactResultsFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyWithReportPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyWithReportArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyWithReportArtifactResultsBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyWithReportArtifactResultsBySiteNumberCommand' in method 'getStudyWithReportPatientArtifactResultsFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchPatientStudies(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, gov.va.med.imaging.exchange.enums.StudyLoadLevel studyLoadLevel
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PrefetchPatientStudiesCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PrefetchPatientStudiesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, gov.va.med.imaging.exchange.enums.StudyLoadLevel.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,studyLoadLevel
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PrefetchPatientStudiesCommand' in method 'prefetchPatientStudies' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postSensitivePatientAccess(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostSensitivePatientAccessCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostSensitivePatientAccessCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostSensitivePatientAccessCommand' in method 'postSensitivePatientAccess' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchExamImageInstance(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		 			, boolean includeTextFile
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PrefetchExamInstanceByImageUrnSyncCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PrefetchExamInstanceByImageUrnSyncCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class, boolean.class 
		  			},
 					new Object[]{
				 		imageUrn,imageFormatQualityList,includeTextFile
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PrefetchExamInstanceByImageUrnSyncCommand' in method 'prefetchExamImageInstance' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchImageInstance(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PrefetchInstanceByImageUrnSyncCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PrefetchInstanceByImageUrnSyncCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,imageFormatQualityList
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PrefetchInstanceByImageUrnSyncCommand' in method 'prefetchImageInstance' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchDocument(
 			gov.va.med.GlobalArtifactIdentifier gai
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PrefetchDocumentCommand' and parameters 'gov.va.med.GlobalArtifactIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PrefetchDocumentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class 
		  			},
 					new Object[]{
				 		gai
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PrefetchDocumentCommand' in method 'prefetchDocument' with parameters 'gov.va.med.GlobalArtifactIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageAnnotations(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageAnnotationListByImageUrnCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotation.class, 
 				"GetImageAnnotationListByImageUrnCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.AbstractImagingURN.class 
	  			},
				new Object[]{
			 		imagingUrn
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetImageAnnotationListByImageUrnCommand' in method 'getImageAnnotations' with parameters 'gov.va.med.imaging.AbstractImagingURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageAnnotationDetails(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, gov.va.med.imaging.ImageAnnotationURN imageAnnotationUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageAnnotationDetailsCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN, gov.va.med.imaging.ImageAnnotationURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails.class, 
	 				"GetImageAnnotationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, gov.va.med.imaging.ImageAnnotationURN.class 
		  			},
 					new Object[]{
				 		imagingUrn,imageAnnotationUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageAnnotationDetailsCommand' in method 'getImageAnnotationDetails' with parameters 'gov.va.med.imaging.AbstractImagingURN, gov.va.med.imaging.ImageAnnotationURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void storeImageAnnotation(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, java.lang.String annotationDetails
 		 			, java.lang.String annotationVersion
 		 			, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource annotationSource
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostImageAnnotationDetailsCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN, java.lang.String, java.lang.String, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotation.class, 
	 				"PostImageAnnotationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource.class 
		  			},
 					new Object[]{
				 		imagingUrn,annotationDetails,annotationVersion,annotationSource
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostImageAnnotationDetailsCommand' in method 'storeImageAnnotation' with parameters 'gov.va.med.imaging.AbstractImagingURN, java.lang.String, java.lang.String, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getUserKeys(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetUserKeysCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetUserKeysCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetUserKeysCommand' in method 'getUserKeys' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDivisionList(
 			java.lang.String accessCode
 		 			, gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDivisionListCommand' and parameters 'java.lang.String, gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Division.class, 
 				"GetDivisionListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		accessCode,routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetDivisionListCommand' in method 'getDivisionList' with parameters 'java.lang.String, gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getUserInformation(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetUserInformationFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.UserInformation.class, 
	 				"GetUserInformationFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetUserInformationFromDataSourceCommand' in method 'getUserInformation' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTreatingSiteNumbers(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, boolean includeTrailingCharactersForSite200
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetTreatingSitesFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, boolean'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetTreatingSitesFromDataSourceCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, boolean.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,includeTrailingCharactersForSite200
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetTreatingSitesFromDataSourceCommand' in method 'getTreatingSiteNumbers' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientInformation(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientInformationCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.Patient.class, 
	 				"GetPatientInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientInformationCommand' in method 'getPatientInformation' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientMeansTest(
 			gov.va.med.RoutingToken routingTokne
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientMeansTestCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.PatientMeansTestResult.class, 
	 				"GetPatientMeansTestCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingTokne,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientMeansTestCommand' in method 'getPatientMeansTest' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImagingLogEvent(
 			gov.va.med.imaging.exchange.ImagingLogEvent imagingLogEvent
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostImagingLogEventCommand' and parameters 'gov.va.med.imaging.exchange.ImagingLogEvent'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostImagingLogEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.ImagingLogEvent.class 
		  			},
 					new Object[]{
				 		imagingLogEvent
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostImagingLogEventCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageAccessReasons(
 			gov.va.med.RoutingToken routingToken
 		 			, java.util.List<gov.va.med.imaging.exchange.enums.ImageAccessReasonType> reasonTypes
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageAccessReasonListCommand' and parameters 'gov.va.med.RoutingToken, java.util.List'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.ImageAccessReason.class, 
 				"GetImageAccessReasonListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.util.List.class 
	  			},
				new Object[]{
			 		routingToken,reasonTypes
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetImageAccessReasonListCommand' in method 'getImageAccessReasons' with parameters 'gov.va.med.RoutingToken, java.util.List'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void verifyElectronicSignature(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String electronicSignature
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetVerifyElectronicSignatureCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ElectronicSignatureResult.class, 
	 				"GetVerifyElectronicSignatureCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,electronicSignature
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetVerifyElectronicSignatureCommand' in method 'verifyElectronicSignature' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getHealthSummaries(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetHealthSummaryTypeListCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.HealthSummaryType.class, 
 				"GetHealthSummaryTypeListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetHealthSummaryTypeListCommand' in method 'getHealthSummaries' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getHealthSummary(
 			gov.va.med.HealthSummaryURN healthSummaryUrn
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientHealthSummaryCommand' and parameters 'gov.va.med.HealthSummaryURN, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetPatientHealthSummaryCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.HealthSummaryURN.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		healthSummaryUrn,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientHealthSummaryCommand' in method 'getHealthSummary' with parameters 'gov.va.med.HealthSummaryURN, gov.va.med.PatientIdentifier'.");
 		}

 }