/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: May 15, 2010
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.federation.rest.endpoints;

/**
 * URI endpoints for REST Patient services
 * 
 * @author DNS
 *
 */
public class FederationPatientRestUri 
{
	/**
	 * Service application
	 */
	public final static String patientServicePath = "patient"; 
	
	/**
	 * Path to retrieve patient sensitivity
	 */
	public final static String patientSensitivePath = "patientSensitive/{routingToken}/{patientIcn}";
	
	/**
	 * Path to retrieve sites patient has been seen at
	 */ 
	public final static String patientVisitedPath = "patient/visited/{routingToken}/{patientIcn}";
	
	public final static String patientVisitedPathV5 = "patient/visited/{routingToken}/{patientIcn}/{includeTrailingCharactersForSite200}";
	
	/**
	 * Path to search for patients
	 */
	public final static String patientSearchPath = "patients/{routingToken}";
	
	public final static String patientLogSensitiveAccessPath = "logPatientSensitive/{routingToken}/{patientIcn}";

	
	public final static String patientInformationPath = "patient/{routingToken}/{patientIcn}";
	
	public final static String patientMeansTestPath = "patient/means/{routingToken}/{patientIcn}";
	
	public final static String healthSummariesPath = "healthsummaries/{routingToken}";
	
	public final static String patientHealthSummaryPath = "patient/healthsummary/{healthSummaryId}/{patientIcn}";
}
