/**
 * 
 */
package gov.va.med.imaging.dicom.spi;

import java.io.IOException;
import java.io.InputStream;

import gov.va.med.imaging.dicom.dataset.DataSet;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;
import gov.va.med.imaging.dicom.exceptions.RawPixelInterpretationValuesNotSetException;

/**
 * @author      DNS
 *
 */
public interface Part10DataSetParserSPI
extends DicomSPI
{
    /**
     * Initialize and return TRUE if initialization completed successfully.
     * Return FALSE if initialization failed.
     * An instance of Part10DataSetParserSPI that returns FALSE will not be called again.
     * 
     * NOTE: Implementations should validate that all required libraries are available
     * and that calls to other methods in this interface will (likely) succeed.
     * 
     * @return
     */
    public boolean initialize();
    
    /**
     * 
     * @param inStream
     * @return
     */
    public DataSet parseInputStreamWithPixels(InputStream inStream);
    
    /**
     * 
     * @param inStream
     * @return
     */
    public DataSet parseInputStreamWithoutPixels(InputStream inStream);
    
    /**
     * 
     * @param inStream
     * @return
     */
    public InputStream parseInputStreamPixelsOnly(InputStream inStream)
    throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException, 
        RawPixelInterpretationValuesNotSetException;
}
