package gov.va.med.imaging.dicom.parser.io;

import gov.va.med.imaging.dicom.dataset.DataSet;
import gov.va.med.imaging.dicom.dataset.TransferSyntaxUid;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;
import gov.va.med.imaging.dicom.exceptions.RawPixelInterpretationValuesNotSetException;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DicomImageExtractor
{

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		File sourceDicomFile = new File(args[0]);
		OutputStream out = null;
		
		System.out.println("Loading file '" + sourceDicomFile.getPath() + "'");
		
		try
		{
		    Part10DataSetLoader loader = Part10DataSetLoader.load( sourceDicomFile );
		    DataSet dataSet = loader.getDataSet();
			
			TransferSyntaxUid transferSyntax = dataSet.getTransferSyntax();
			String imageMimeType = transferSyntax.getMimeType();
			String destFileExtension = imageMimeType.split("/")[1];
			
			File destFile = new File(sourceDicomFile.getParent(), sourceDicomFile.getName().split("\\x2e")[0] + "." + destFileExtension);
			out = new FileOutputStream(destFile);
			
			extractImage(dataSet, out);
		}
		catch(Exception x)
		{
			x.printStackTrace();
		}
		finally
		{
			try{out.close();}catch(Exception x){}
		}
	}

	private static void extractImage(DataSet dataSet, OutputStream out) 
	throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException, RawPixelInterpretationValuesNotSetException
    {
		//BufferedImage image = dataSet.getFirstImage();
   }

}
