/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.TransferSyntaxUid;
import gov.va.med.imaging.dicom.dataset.elements.DataElement_US;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;

/**
 * @author       DNS
 *
 */
public class RawValueParser_US 
extends RawValueParser<Integer[], DataElement_US>
{

    public RawValueParser_US(DataElementFactory factory, DataElement_US dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() 
    throws DicomFormatException
    {
        TransferSyntaxUid transferSyntax = this.getFactory().getTransferSyntaxUid();
        
        int count = getDataElement().getRawValue().length / 2;       // every two bytes is an integer
        Integer[] value = new Integer[getDataElement().getRawValue().length / 2];
        for(int index=0; index < count; ++index)
            value[index] = 
                new Integer( TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(transferSyntax.isLittleEndian(), getDataElement().getRawValue(), index*2) );

        getDataElement().setValue(value);
    }

}
