/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_UL;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;

/**
 * @author       DNS
 *
 */
public class RawValueParser_UL 
extends RawValueParser<Long, DataElement_UL>
{

    public RawValueParser_UL(DataElementFactory factory, DataElement_UL dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() 
    throws DicomFormatException
    {
        getDataElement().setValue( new Long( TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(
                this.getFactory().getTransferSyntaxUid().isLittleEndian(), getDataElement().getRawValue()) ) );
    }

}
