/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_UI;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException_UI;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author       DNS
 *
 */
public class RawValueParser_UI 
extends RawValueParser<String, DataElement_UI>
{
    private static Pattern UID_PATTERN = Pattern.compile("([\\d]+)(\\x2e[\\d]+)*");

    public RawValueParser_UI(DataElementFactory factory, DataElement_UI dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() 
    throws DicomFormatException
    {
        String value = new String(getDataElement().getRawValue());
        value = value.trim();
        Matcher matcher = UID_PATTERN.matcher(value);
        if( ! matcher.matches() )
        {
            getLogger().log(Level.WARNING, "UID '" + value + "' is not in the correct form.");
            throw new DicomFormatException_UI(value);
        }
        getDataElement().setValue(value);
    }

}
