/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_TM;
import gov.va.med.imaging.dicom.exceptions.DicomDateFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author       DNS
 *
 */
public class RawValueParser_TM 
extends RawValueParser<Long, DataElement_TM>
{
    private static Pattern TIME_PATTERN = Pattern.compile(   "([\\d]{2})([\\d]{2})?([\\d]{2})?(\\x2e[\\d]{1,6})?");

    public RawValueParser_TM(DataElementFactory factory, DataElement_TM dataElement)
    {
        super(factory, dataElement);
        // TODO Auto-generated constructor stub
    }

    @Override
    public void parseRawValue() throws DicomFormatException
    {
        if(getDataElement().getRawValue() == null || getDataElement().getRawValue().length == 0)
            getDataElement().setValue( new Long(0L) );
        else
        {
            String rawValueAsString = new String(getDataElement().getRawValue());
            Matcher patternMatcher = TIME_PATTERN.matcher(rawValueAsString);
            if(! patternMatcher.matches() )
                throw new DicomDateFormatException("The value '" + rawValueAsString + "' is not a valid DICOM TM element.");
            String hours = patternMatcher.group(1);
            String minutes = patternMatcher.groupCount() > 2 ? patternMatcher.group(2) : "0";
            String seconds = patternMatcher.groupCount() > 3 ? patternMatcher.group(3) : "0";
            String subseconds = patternMatcher.groupCount() > 4 ? patternMatcher.group(4) : ".0000";
    
            long tmpValue;
            try
            {
                tmpValue = (Integer.parseInt(hours) * 60l * 60l * 1000l);
                tmpValue += (Integer.parseInt(minutes) * 60l * 1000l);
                tmpValue += (Integer.parseInt(seconds) * 1000l);
                tmpValue += Integer.parseInt(subseconds.substring(1));
            } 
            catch (NumberFormatException e)
            {
                throw new DicomDateFormatException("The value '" + rawValueAsString + "' is not a valid DICOM TM element, it contains non-numeric characters.");
            }
            
            getDataElement().setValue( new Long(tmpValue) );
        }
    }

}
