/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

/**
 * Use when parseRawValue just makes a String from the raw value.
 * 
 * @author       DNS
 *
 */
public abstract class RawValueParser_String<E extends DataElement<String>> 
extends RawValueParser<String, E>
{
    public RawValueParser_String(DataElementFactory factory, E dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue()
    throws DicomFormatException
    {
        if(getDataElement().getRawValue() == null)
            getDataElement().setValue("");
        else
            getDataElement().setValue( new String(getDataElement().getRawValue()) );
    }

}
