/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_SS;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;

/**
 * @author      DNS
 *
 */
public class RawValueParser_SS 
extends RawValueParser<Integer, DataElement_SS>
{

    public RawValueParser_SS(DataElementFactory factory, DataElement_SS dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() throws DicomFormatException
    {
        getDataElement().setValue( new Integer( TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(
                this.getFactory().getTransferSyntaxUid().isLittleEndian(), getDataElement().getRawValue()) ) );
    }

}
