/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.DataSet;
import gov.va.med.imaging.dicom.dataset.elements.DataElement_SQ;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.IncompatibleValueLengthField;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;
import gov.va.med.imaging.dicom.parser.io.DataElementLimitedInputStream;
import gov.va.med.imaging.dicom.parser.io.DataElementReader;
import gov.va.med.imaging.dicom.parser.io.DataSetReader;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;

/**
 * @author      DNS
 *
 */
public class RawValueParser_SQ 
extends RawValueParser<List<DataSet>, DataElement_SQ>
{

    public RawValueParser_SQ(DataElementFactory factory, DataElement_SQ dataElement)
    {
        super(factory, dataElement);
    }

    /**
     * @see gov.va.med.imaging.hi5.shared.dicom.dataelement.DataElement#parseRawValue()
     */
    @Override
    public void parseRawValue() 
    throws DicomFormatException
    {
        DataInputStream inStream = new DataInputStream( new ByteArrayInputStream(getDataElement().getRawValue()) ); 
        parseInputStream(inStream);
    }

    /**
     */
    protected void parseInputStream(DataInputStream inStream)
    {
        DataElementLimitedInputStream dataElementInputStream = 
            new DataElementLimitedInputStream( inStream, getFactory().getTransferSyntaxUid() );
        DataElementReader reader = new DataElementReader(dataElementInputStream, getFactory());
        try
        {
            reader.readNextDataElement();
            DataSetReader childSetReader = new DataSetReader(dataElementInputStream, getFactory());
            childSetReader.readDataSet();
        } 
        catch (IOException e)
        {
            e.printStackTrace();
        } 
        catch (InvalidVRModeException e)
        {
            e.printStackTrace();
        } 
        catch (InvalidVRException e)
        {
            e.printStackTrace();
        } 
        catch (IncompatibleValueLengthField e)
        {
            e.printStackTrace();
        } 
        catch (DicomFormatException e)
        {
            e.printStackTrace();
        }
    }

}
