/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_SL;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;

/**
 * @author     DNS
 *
 */
public class RawValueParser_SL 
extends RawValueParser<Long, DataElement_SL>
{

    public RawValueParser_SL(DataElementFactory factory, DataElement_SL dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() throws DicomFormatException
    {
       getDataElement().setValue( new Long( 
            TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(this.getFactory().getTransferSyntaxUid().isLittleEndian(), getDataElement().getRawValue()) 
        ) );
    }

}
