/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_OW;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException_OW;
import gov.va.med.imaging.dicom.exceptions.RawPixelInterpretationValuesNotSetException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawDataToPixelTransformer;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;

/**
 * @author       DNS
 *
 */
public class RawValueParser_OW 
extends RawValueParser_NativePixelDataElement<DataElement_OW>
{
    private List<BufferedImage> bufferedImages = null;
    
    public RawValueParser_OW(DataElementFactory factory,
            DataElement_OW dataElement)
    {
        super(factory, dataElement);
        // TODO Auto-generated constructor stub
    }

    @Override
    public void parseRawValue() throws DicomFormatException
    {
        if(getDataElement().getRawValue() == null)
            getDataElement().setRawValue(new byte[0]);
        else if(getDataElement().getRawValue().length % 2 > 0)
            throw new DicomFormatException_OW("The length of the raw value array must be an even number of bytes and it is not.");
        else
        {
            TransferSyntaxUidUtility.intepretByteArrayAsWordArray(
                getFactory().getTransferSyntaxUid().isLittleEndian(), getDataElement().getRawValue()
            );
        }
    }

    /**
     * Returns an array of int, one for each pixel, each is a maximum of 8 significant bits
     * per pixel (unsigned values, hence the wasted bits)
     * 
     * If native, it shall have a defined Value Length, and be encoded as follows:
     * - where Bits Allocated (0028,0100) has a value greater than 8 shall have 
     *   Value Representation OW and shall be encoded in Little Endian;
     * - where Bits Allocated (0028,0100) has a value less than or equal to 8 shall have the 
     *   Value Representation OB or OW and shall be encoded in Little Endian.
     * 
     * The raw data is organized in chunks specified by the bitsAllocated parameter.
     * The only guarantee is that the bitsAllocated must be less than 8 bits (else the
     * image must be stored in a OW element.
     * 
     * @throws DicomFormatException 
     * @see gov.va.med.imaging.hi5.shared.dicom.dataelement.NativePixelDataElement#getRawPixelData(int, int, int)
     */
    public synchronized List<BufferedImage> getBufferedImages()
    throws DicomFormatException, RawPixelInterpretationValuesNotSetException
    {
        if(getFactory().getTransferSyntaxUid().isEncapsulated())
            return null;
        
        if (this.bufferedImages == null)
        {
            if (getDataElement().getBitsAllocated() == 0 || getDataElement().getBitsStored() == 0)
                throw new RawPixelInterpretationValuesNotSetException();

            this.bufferedImages = new ArrayList<BufferedImage>();
            
            int[] destination = getRawPixels();

            DataBuffer dataBuffer = new DataBufferInt(destination, destination.length);
            WritableRaster imageRaster = 
                WritableRaster.createPackedRaster(dataBuffer, getDataElement().getWidth(), getDataElement().getHeight(), getDataElement().getBitsStored(), new Point(0,0));
            
            //BufferedImage image = new BufferedImage(createColorModel(ColorSpace.CS_GRAY, 16), imageRaster, true, null);
            BufferedImage image = new BufferedImage(getDataElement().getWidth(), getDataElement().getHeight(), BufferedImage.TYPE_USHORT_GRAY);
            
            image.setData(imageRaster);
            
            this.bufferedImages.add(image);
        }
        
        return this.bufferedImages;
    }
    
    /**
     * 
     */
    public int[] getRawPixels() 
    throws DicomFormatException
    {
        RawDataToPixelTransformer transformer = new RawDataToPixelTransformer(true);
        
        return transformer.transformRawByteDataToIntPixelArray(
            getDataElement().getRawValue(), 
            getDataElement().getHeight(), getDataElement().getWidth(), 
            getDataElement().getBitsAllocated(), getDataElement().getBitsStored(), getDataElement().getHighBit());
    }
}
