package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_OF;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException_OF;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;

public class RawValueParser_OF 
extends RawValueParser<Float[], DataElement_OF>
{

    public RawValueParser_OF(DataElementFactory factory, DataElement_OF dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() throws DicomFormatException
    {
        if(getDataElement().getRawValue() == null)
            getDataElement().setValue( new Float[0] );
        else if(getDataElement().getRawValue().length % 4 > 0)
            throw new DicomFormatException_OF();
        else
        {
            int count = getDataElement().getRawValue().length / 4;
            Float[] value = new Float[count];
            for(int index = 0; index < count; index++)
                value[index] = TransferSyntaxUidUtility.makeFloatFrom4Bytes(
                        getFactory().getTransferSyntaxUid().isLittleEndian(), getDataElement().getRawValue(), index * 4);
            
            getDataElement().setValue(value);
        }
    }
}
