/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_IS;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException_IS;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

/**
 * @author       DNS
 *
 */
public class RawValueParser_IS 
extends RawValueParser<Integer, DataElement_IS>
{
    
    public RawValueParser_IS(DataElementFactory factory, DataElement_IS dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() throws DicomFormatException
    {
        if(getDataElement().getRawValue() == null)
            getDataElement().setValue( new Integer(0) );
        else
        {
            String tmp = new String(getDataElement().getRawValue());
            tmp = tmp.trim();
            try
            {
                getDataElement().setValue( Integer.parseInt(tmp) );
            } 
            catch (NumberFormatException e)
            {
                throw new DicomFormatException_IS(tmp);
            }
        }
    }

}
