/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_FL;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;

import java.util.logging.Level;

/**
 * @author       DNS
 *
 */
public class RawValueParser_FL 
extends RawValueParser<Float, DataElement_FL>
{

    public RawValueParser_FL(DataElementFactory factory, DataElement_FL dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() throws DicomFormatException
    {
        if(getDataElement().getRawValue() == null || getDataElement().getRawValue().length == 0)
            getDataElement().setValue( new Float(0) );
        else
        {
            try
            {
                getDataElement().setValue( TransferSyntaxUidUtility.makeFloatFrom4Bytes(
                        getFactory().getTransferSyntaxUid().isLittleEndian(),
                        getDataElement().getRawValue()) );
            } 
            catch (Exception e)
            {
                getLogger().log(Level.WARNING, "");
                throw new ValueRepresentationInterpretationException("Value '" + getRawValueCharacterRepresentation(getDataElement())+ "' could not be interpreted as a Floating Point String");
            }
        }       
    }

}
