/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_FD;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;

import java.util.logging.Level;

/**
 * @author       DNS
 *
 */
public class RawValueParser_FD 
extends RawValueParser<Double, DataElement_FD>
{

    public RawValueParser_FD(DataElementFactory factory, DataElement_FD dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() 
    throws DicomFormatException
    {
        if(getDataElement().getRawValue() == null)
            getDataElement().setValue( new Double(0) );
        
        try
        {
            long bits = TransferSyntaxUidUtility.makeUnsignedLongFrom8Bytes(
                getFactory().getTransferSyntaxUid().isLittleEndian(), getDataElement().getRawValue()
            );
            getDataElement().setValue( new Double( Double.longBitsToDouble(bits) ) );
        } 
        catch (Exception e)
        {
            getLogger().log(Level.WARNING, "");
            throw new ValueRepresentationInterpretationException("Value '" + getDataElement().getRawValue()+ "' could not be interpreted as a Floating Point String");
        }
    }
}
