package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_DT;
import gov.va.med.imaging.dicom.exceptions.DicomDateFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.DicomDateFormat;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class RawValueParser_DT 
extends RawValueParser<Date, DataElement_DT>
{
    private DateFormat df = new DicomDateFormat();
    
    public RawValueParser_DT(DataElementFactory factory, DataElement_DT dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() 
    throws DicomFormatException
    {
        String tmp = new String(getDataElement().getRawValue());
        try
        {
            getDataElement().setValue( df.parse(tmp) );
        } 
        catch (ParseException e)
        {
            throw new DicomDateFormatException(tmp);
        }
    }
}
