/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_DS;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

import java.math.BigDecimal;

/**
 * @author       DNS
 *
 */
public class RawValueParser_DS 
extends RawValueParser<BigDecimal[], DataElement_DS>
{
    public RawValueParser_DS(DataElementFactory factory, DataElement_DS dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() 
    throws DicomFormatException
    {
        String tmp = RawValueParser.transformValueToStringRemoveNulls(getDataElement().getRawValue(), getDataElement().getValueLength());
        tmp = tmp.trim();
        String[] tmpElements = tmp.split("\\\\");
        BigDecimal[] value = new BigDecimal[tmpElements.length];
        try
        {
            for( int index=0; index < tmpElements.length; ++index )
                value[index] = new BigDecimal(tmpElements[index]);
            
            getDataElement().setValue(value);
        } 
        catch (NumberFormatException e)
        {
            getLogger().warning("The data element value '" + tmp + "' is not interpretable as a Decimal String value representation, ignoring...");
            //throw new DicomFormatException_DS(tmp);
        }
    }
}
