/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_DA;
import gov.va.med.imaging.dicom.exceptions.DicomDateFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.DicomDateFormat;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

/**
 * @author      DNS
 *
 */
public class RawValueParser_DA 
extends RawValueParser<Date, DataElement_DA>
{
    public RawValueParser_DA(DataElementFactory factory, DataElement_DA dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue() 
    throws DicomFormatException
    {
        DateFormat df = new DicomDateFormat();
        
        if(getDataElement().getRawValue() == null || getDataElement().getRawValue().length == 0)
            getDataElement().setValue(new Date(0L));
        else
        {
            String tmp = new String(getDataElement().getRawValue());
            try
            {
                getDataElement().setValue( df.parse(tmp) );
            } 
            catch (ParseException e)
            {
                throw new DicomDateFormatException(tmp);
            }
        }
    }
}
