/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElementTag;
import gov.va.med.imaging.dicom.dataset.elements.DataElement_AT;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;

/**
 * @author       DNS
 *
 */
public class RawValueParser_AT 
extends RawValueParser<DataElementTag, DataElement_AT>
{
    public RawValueParser_AT(DataElementFactory factory, DataElement_AT dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue()
    throws DicomFormatException
    {
        boolean littleEndian = getFactory().getTransferSyntaxUid().isLittleEndian();
        getDataElement().setValue( new DataElementTag(
            TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(littleEndian, getDataElement().getRawValue(), 0),
            TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(littleEndian, getDataElement().getRawValue(), 2) ) );
    }

}
