/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_AS;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException_AS;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

import java.util.regex.Pattern;

/**
 * @author       DNS
 *
 */
public class RawValueParser_AS 
extends RawValueParser<String, DataElement_AS>
{
    private static final Pattern ageStringPattern = Pattern.compile("[\\d]{3}[DWMY]");

    public RawValueParser_AS(DataElementFactory factory, DataElement_AS dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue()
    throws DicomFormatException
    {
        if(getDataElement().getRawValue() == null)
            getDataElement().setValue(null);
        
        validateLengthValues(getDataElement());
        
        String value = getDataElement().getRawValue() == null ? null : new String(getDataElement().getRawValue()).trim();
        if(value != null)
            if( !ageStringPattern.matcher(value).matches() )
                throw new DicomFormatException_AS(getDataElement().getValue());
        getDataElement().setValue(value);
    }

}
