/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement_AE;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationValueLengthInsufficientException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

/**
 * @author     DNS
 *
 */
public class RawValueParser_AE 
extends RawValueParser<String, DataElement_AE>
{
    public RawValueParser_AE(DataElementFactory factory, DataElement_AE dataElement)
    {
        super(factory, dataElement);
    }

    @Override
    public void parseRawValue()
    throws DicomFormatException
    {
        if(getDataElement().getRawValue() == null)
            getDataElement().setValue(null);
        
        validateLengthValues(getDataElement());
        
        String value = getDataElement().getRawValue() == null ? null : new String(getDataElement().getRawValue()).trim();
        if(value != null)
            if(value.length() < getDataElement().getValueRepresentation()[0].getMinLengthOfValue())
                throw new ValueRepresentationValueLengthInsufficientException();
        
        getDataElement().setValue(value);
    }

}
