package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.dataset.elements.DataElement;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.RawValueParser;

import java.lang.reflect.Constructor;

/**
 * Create RawValueParser instances using a naming convention.
 * 
 * @author      DNS
 *
 */
public class RawValueParserFactory
{
    private final DataElementFactory dataElementFactory;
    
    public RawValueParserFactory(DataElementFactory dataElementFactory)
    {
        this.dataElementFactory = dataElementFactory;
    }
    
    private static final String DATA_ELEMENT_CLASSNAME_PREFIX = "DataElement_";
    private static final int DATA_ELEMENT_CLASSNAME_PREFIX_LENGTH = DATA_ELEMENT_CLASSNAME_PREFIX.length();
    private static final String RAW_VALUE_PARSER_CLASSNAME_PREFIX = "RawValueParser_";
    private static final String PACKAGE_NAME = RawValueParserFactory.class.getPackage().getName();
    
    /**
     * 
     * @param <T>
     * @param <E>
     * @param dataElement
     * @return
     */
    public <T, E extends DataElement<T>> RawValueParser<T, E> createRawValueParser(DataElement<T> dataElement)
    {
        Class<?> dataElementClass = dataElement.getClass();
        String dataElementSimpleClassName = dataElementClass.getSimpleName();
        if( dataElementSimpleClassName.startsWith(DATA_ELEMENT_CLASSNAME_PREFIX) )
        {
            String dataElementVR = dataElementSimpleClassName.substring(DATA_ELEMENT_CLASSNAME_PREFIX_LENGTH);
            String rawValueParserClassName = PACKAGE_NAME + "." + RAW_VALUE_PARSER_CLASSNAME_PREFIX + dataElementVR;
            try
            {
                Class<?> rawValueParserClass = Class.forName(rawValueParserClassName);
                Constructor<?> ctor = rawValueParserClass.getConstructor(DataElementFactory.class, dataElementClass);
                @SuppressWarnings("unchecked")
                RawValueParser<T, E> rawValueParser = 
                    (RawValueParser<T, E>)ctor.newInstance(this.dataElementFactory, dataElement);
                return rawValueParser;
            } 
            catch (Exception e)
            {
                e.printStackTrace();
                
            }
        }
        
        return null;
    }
}
