package gov.va.med.imaging.dicom.parser.impl.rawvalueparsers;

import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

/**
 * An interface, implemented by select DataElement derivations, to interpret raw byte (or word) arrays
 * as image data (i.e. 7FE0:0010). 
 * 
 * @author DNS
 *
 * Some relevant quotes from the specification:
 * Data Element (7FE0,0010) Pixel Data may be encapsulated or native.
 * If native, it shall have a defined Value Length, and be encoded as follows:
 * - where Bits Allocated (0028,0100) has a value greater than 8 shall have 
 *   Value Representation OW and shall be encoded in Little Endian;
 * - where Bits Allocated (0028,0100) has a value less than or equal to 8 shall have the 
 *   Value Representation OB or OW and shall be encoded in Little Endian.
 *   
 * If encapsulated, it has the Value Representation OB and is a sequence of bytes resulting from one of the 
 * encoding processes. It contains the encoded pixel data stream fragmented into one or more Item(s). 
 * This Pixel Data Stream may represent a Single or Multi-frame Image. See Tables A.4-1 and A.4-2:
 * - The Length of the Data Element (7FE0,0010) shall be set to the Value for Undefined Length (FFFFFFFFH).
 * - Each Data Stream Fragment encoded according to the specific encoding process shall be encapsulated as a 
 *   DICOM Item with a specific Data Element Tag of Value (FFFE,E000). The Item Tag is followed by a 4 byte 
 *   Item Length field encoding the explicit number of bytes of the Item.
 * - All items containing an encoded fragment shall be made of an even number of bytes greater or equal to two. 
 *   The last fragment of a frame may be padded, if necessary, to meet the sequence item format requirements of the 
 *   DICOM Standard.
 *   
 *   
 */
public interface EncapsulatedPixelDataElement
{
	public List<BufferedImage> getEncapsulatedPixelData() 
		throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException;
}
