package gov.va.med.imaging.dicom.parser.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import gov.va.med.imaging.dicom.dataset.DataSet;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;
import gov.va.med.imaging.dicom.exceptions.RawPixelInterpretationValuesNotSetException;
import gov.va.med.imaging.dicom.parser.io.ArrayConversion;
import gov.va.med.imaging.dicom.parser.io.Part10DataSetLoader;
import gov.va.med.imaging.dicom.spi.Part10DataSetParserSPI;

/**
 * An implementation of the Part10DataSetParserSPI that uses the homegrown DICOM parser.
 * 
 * @author       DNS
 */
public class Part10DataSetParserImpl
implements Part10DataSetParserSPI
{
    @Override
    public boolean initialize()
    {
        return true;        // no initialization necessary
    }

    @Override
    public DataSet parseInputStreamWithPixels(InputStream inStream)
    {
        Part10DataSetLoader loader = null;
        DataSet dicomDataSet = null;

        try
        {
            loader = Part10DataSetLoader.load(inStream);
            dicomDataSet = loader.getDataSet();
        } 
        catch (Exception e)
        {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        } 
        finally
        {
            try{inStream.close();} 
            catch (IOException e){e.printStackTrace();} 
        }
        
        return dicomDataSet;
    }

    @Override
    public DataSet parseInputStreamWithoutPixels(InputStream inStream)
    {
        Part10DataSetLoader loader = null;
        DataSet dicomDataSet = null;

        try
        {
            loader = Part10DataSetLoader.load(inStream);
            dicomDataSet = loader.getDataSet();
        } 
        catch (Exception e)
        {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        } 
        finally
        {
            try{inStream.close();} 
            catch (IOException e){e.printStackTrace();} 
        }
        
        return dicomDataSet;
    }

    @Override
    public InputStream parseInputStreamPixelsOnly(InputStream inStream) 
    throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException, RawPixelInterpretationValuesNotSetException
    {
        Part10DataSetLoader loader = null;
        DataSet dicomDataSet = null;

        try
        {
            loader = Part10DataSetLoader.load(inStream);
            dicomDataSet = loader.getDataSet();
        } 
        catch (Exception e)
        {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        } 
        finally
        {
            inStream.close(); 
        }
        
        return new ByteArrayInputStream(getDICOMPixels(loader.getDataElementFactory(), dicomDataSet));
    }

    /**
     * 
     * @param dicomDataSet
     * @return
     * @throws DicomFormatException
     * @throws IOException
     * @throws InvalidVRModeException
     * @throws InvalidVRException
     * @throws RawPixelInterpretationValuesNotSetException
     */
    private byte[] getDICOMPixels(
        DataElementFactory factory,
        DataSet dicomDataSet) 
    throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException,
           RawPixelInterpretationValuesNotSetException
    {
        int[] imageFrame = DataSetUtility.getRawPixels(factory, dicomDataSet);
        return ArrayConversion.integerArrayToByteArray(imageFrame);
    }

}
