package gov.va.med.imaging.dicom.parser.impl;

import gov.va.med.imaging.dicom.DicomServiceProvider;
import gov.va.med.imaging.dicom.DicomServiceDescription;
import gov.va.med.imaging.dicom.spi.Part10DataSetParserSPI;

import java.util.SortedSet;
import java.util.TreeSet;

/**
 * 
 * @author       DNS
 *
 */
public class HomeGrownDicomServiceProvider
extends DicomServiceProvider
{
    private static final String PROVIDER_NAME = "HomeGrownDICOM";
    private static final float PROVIDER_VERSION = 0.0f;
    private static final String PROVIDER_INFO = 
        "Implements: \n" + 
        "Part10DataSetParserSPI \n" + 
        "in pure Java.  Implementation is questionable for production use.";

    private static final long serialVersionUID = 1L;
    
    private final SortedSet<DicomServiceDescription<?>> services;

    /**
     * The public "nullary" constructor that is used by the ServiceLoader class
     * to create instances.
     */
    public HomeGrownDicomServiceProvider()
    {
        this(PROVIDER_NAME, PROVIDER_VERSION, PROVIDER_INFO);
    }

    /**
     * @param name
     * @param version
     * @param info
     */
    public HomeGrownDicomServiceProvider(String name, float version, String info)
    {
        super(name, version, info);

        services = new TreeSet<DicomServiceDescription<?>>();
        
        services.add(
            new DicomServiceDescription<Part10DataSetParserSPI>(
                this, 
                Part10DataSetParserSPI.class,
                0.0F,                           // the version should always be 0.0, this should be the last DICOM parser chosen
                Part10DataSetParserImpl.class,
                true)
            );
    }
    
    @Override
    protected SortedSet<DicomServiceDescription<?>> getServices()
    {
        return this.services;
    }

    /**
     * No initialization required, is always available
     */
    @Override
    public boolean initialize()
    {
        return true;
    }
}
