/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl;

import gov.va.med.imaging.dicom.dataset.DataSet;
import gov.va.med.imaging.dicom.dataset.elements.DataElement;
import gov.va.med.imaging.dicom.dataset.elements.DataElementTag;
import gov.va.med.imaging.dicom.dataset.elements.DataElement_OB;
import gov.va.med.imaging.dicom.dataset.elements.DataElement_OW;
import gov.va.med.imaging.dicom.dataset.elements.NativePixelDataElement;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;
import gov.va.med.imaging.dicom.exceptions.RawPixelInterpretationValuesNotSetException;
import gov.va.med.imaging.dicom.parser.impl.rawvalueparsers.RawValueParser_OB;
import gov.va.med.imaging.dicom.parser.impl.rawvalueparsers.RawValueParser_OW;

import java.io.IOException;

/**
 * @author       DNS
 *
 */
public class DataSetUtility 
{
//    public BufferedImage getImage(int frame) 
//    throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException, RawPixelInterpretationValuesNotSetException
//    {
//        List<BufferedImage> frames = getImageFrames();
//        
//        return frames == null ? null : frames.get(frame);
//    }
//    
//    public int getFrameCount()
//    throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException, RawPixelInterpretationValuesNotSetException
//    {
//        List<BufferedImage> frames = getImageFrames();
//        return frames == null ? 0 : frames.size();
//    }
//    
//    public BufferedImage getFirstImage() 
//    throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException, RawPixelInterpretationValuesNotSetException
//    {
//        return getImage(0);
//    }

//    public List<BufferedImage> getImageFrames() 
//    throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException, RawPixelInterpretationValuesNotSetException
//    {
//        DataElement<?> imageElement = get(DataElementTag.PIXEL_DATA_TAG);
//        
//        // if the image is an encapsulated type (i.e. jpg, gif, etc) then use getEncapsulatedPixelData()
//        if( getTransferSyntax().isEncapsulated() && imageElement != null && imageElement instanceof DataElement_OB )
//            return ((DataElement_OB)imageElement).getEncapsulatedPixelData();
//        
//        else if( imageElement != null && imageElement instanceof NativePixelDataElement )
//        {
//            NativePixelDataElement nativePixelDataElement = (NativePixelDataElement)imageElement;
//            int bitsAllocated = getBitsAllocated();
//            int bitsStored =  getBitsStored();
//            int highBit = getHighBit();
//            int width = getColumns();
//            int height = getRows();
//            nativePixelDataElement.setNativePixelInterpretationParameters(bitsAllocated, bitsStored, highBit, width, height);
//            return nativePixelDataElement.getBufferedImages();
//        }
//        
//        return null;
//    }
    
    /**
     * 
     * @param elementTag
     * @return
     */
    public static DataElement<?> get(DataSet dataSet, String elementTag)
    {
        return dataSet.get(DataElementTagFactory.create(elementTag));
    }
    
    /**
     * 
     * @param factory 
     * @return
     */
    public static int[] getRawPixels(DataElementFactory factory, DataSet dataSet)
    throws DicomFormatException, IOException, InvalidVRModeException, InvalidVRException, RawPixelInterpretationValuesNotSetException
    {
        DataElement<?> imageElement = dataSet.get(DataElementTag.PIXEL_DATA_TAG);
        
        if( imageElement != null && imageElement instanceof NativePixelDataElement )
        {
            NativePixelDataElement nativePixelDataElement = (NativePixelDataElement)imageElement;
            int bitsAllocated = dataSet.getBitsAllocated();
            int bitsStored =  dataSet.getBitsStored();
            int highBit = dataSet.getHighBit();
            int width = dataSet.getColumns();
            int height = dataSet.getRows();
            nativePixelDataElement.setNativePixelInterpretationParameters(bitsAllocated, bitsStored, highBit, width, height);
            
            if(imageElement instanceof DataElement_OB)
            {
                RawValueParser_OB parser = new RawValueParser_OB(factory, (DataElement_OB)imageElement);
                return parser.getRawPixels();
            }
            else if(imageElement instanceof DataElement_OW)
            {
                RawValueParser_OW parser = new RawValueParser_OW(factory, (DataElement_OW)imageElement);
                return parser.getRawPixels();
            }
        }
        
        return null;
    }

}
