/**
 * 
 */
package gov.va.med.imaging.dicom.parser.impl;

import gov.va.med.imaging.dicom.dataset.elements.DataElementTag;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author       DNS
 *
 */
public class DataElementTagFactory
{
    private static String ElementRegex = "[0x28]?0[xX]([\\d]{4}),0[xX]([\\d]{4})[0x29]?";
    private static Pattern elementPattern = Pattern.compile(ElementRegex);
    
    /**
     * A factory method to maintain compatibility with the String based element keys
     * used in the original version.
     * 
     * @param elementKeyAsString
     * @throws IllegalArgumentException
     */
    public static DataElementTag create(String elementKeyAsString)
    throws IllegalArgumentException
    {
        String elementAsString = elementKeyAsString.replace(" ", "");
        Matcher matcher = elementPattern.matcher(elementAsString);
        
        if( matcher.find() )
        {
            int group = Integer.parseInt( matcher.group(1) );
            int element = Integer.parseInt( matcher.group(2) );
            return new DataElementTag(group, element);
        }
        else
            throw new IllegalArgumentException("The given String '" + elementKeyAsString + "' is not parsable as an element key.");
    }
    

}
