package gov.va.med.imaging.dicom.parser.impl;

import gov.va.med.imaging.dicom.dataset.TransferSyntaxUid;
import gov.va.med.imaging.dicom.dataset.ValueRepresentation;
import gov.va.med.imaging.dicom.dataset.elements.DataElement;
import gov.va.med.imaging.dicom.dataset.elements.DataElementTag;
import gov.va.med.imaging.dicom.dictionary.DicomDictionary;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;

public interface DataElementFactory
{

    /**
     * @return the dictionary
     */
    public abstract DicomDictionary getDictionary();

    /**
     * 
     * @return
     */
    public abstract TransferSyntaxUid getTransferSyntaxUid();

    /**
     * @return the explicitVR
     */
    public abstract boolean isExplicitVR();

    /**
     * @return the littleEndian
     */
    public abstract boolean isLittleEndian();

    /**
     * @return the createUnknownDataElementTag
     */
    public abstract boolean isCreateUnknownDataElementTag();

    /**
     * Create a DataElement of any VR except SQ.
     * 
     * @param dataElementTag
     * @param ValueRepresentation vrField
     * @param valueLength
     * @param value
     * @return
     */
    public abstract DataElement<?> createDataElement(
            DataElementTag dataElementTag, ValueRepresentation vrField, // must be null if implicit VR, must be non-null if explicit VR
            long valueLength, byte[] value) throws InvalidVRModeException;

    /**
     * Return the first VR associated to the given DataElementTag (group and element number)
     * using the dictionary associated to this factory.
     * 
     * @param dataElementTag
     * @return
     */
    public abstract ValueRepresentation getImplicitVR(
            DataElementTag dataElementTag);

}