/**
 * 
 */
package gov.va.med.imaging.dicom.dictionary.impl;

import gov.va.med.imaging.dicom.dataset.elements.DataElementTag;
import gov.va.med.imaging.dicom.dictionary.DicomDictionary;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author      DNS
 *
 */
public class DicomDictionaryUtility
{
    private static String ElementRegex = "[0x28]?0[xX]([\\d]{4}),0[xX]([\\d]{4})[0x29]?";
    private static Pattern elementPattern = Pattern.compile(ElementRegex);
    
    /**
     * 
     * @param dictionary
     * @param elementAsString
     * @return
     */
    public static DicomDictionaryEntry getByElement(DicomDictionary dictionary, String elementAsString)
    {
        elementAsString = elementAsString.replace(" ", "");
        Matcher matcher = elementPattern.matcher(elementAsString);
        
        if( matcher.find() )
        {
            int group = Integer.parseInt( matcher.group(1) );
            int element = Integer.parseInt( matcher.group(2) );
            
            return getByElementKey(dictionary, group, element);
        }
        
        return null;
    }
    
    public static DicomDictionaryEntry getByElementKey(DicomDictionary dictionary, DataElementTag elementKey)
    {
        return getByElementKey(dictionary, elementKey.getGroup(), elementKey.getElement());
    }
    
    public static DicomDictionaryEntry getByElementKey(DicomDictionary dictionary, int group, int element)
    {
        for(String dicomElementName : dictionary.keySet())
        {
            DicomDictionaryEntry entry = dictionary.get(dicomElementName);
            if( group >= entry.getGroupStart() && group <= entry.getGroupEnd() &&
                element >= entry.getElementStart() && element <= entry.getElementEnd())
                    return entry;
        }
        
        return null;
    }
    

}
