/**
 * 
 */
package gov.va.med.imaging.dicom.dictionary.impl;

import gov.va.med.imaging.dicom.dictionary.DicomDictionary;

import java.io.IOException;
import java.io.InputStreamReader;

/**
 * @author       DNS
 *
 */
public class DicomDictionaryFactory
{
    private static DicomDictionary defaultInstance = null;
    private static DicomDictionary defaultHeaderInstance = null;
    
    public static synchronized DicomDictionary getDefault()
    {
        if(defaultInstance == null)
        {
            InputStreamReader reader = null;
            try
            {
                reader = new InputStreamReader(
                    DicomDictionary.class.getClassLoader().getResourceAsStream("DicomDictionary.txt") );
                defaultInstance = DicomDictionaryReaderImpl.create(reader);
            } 
            catch (IOException e)
            {
                e.printStackTrace();
            }
            finally
            {
                try{reader.close();}catch(Exception x){}
            }
        }
        
        return defaultInstance;
    }
    
    /**
     * Return the default dictionary for DICOM header information.  This dictionary contains ONLY
     * the elements that are permitted in the header.
     * 
     * @return
     */
    public static synchronized DicomDictionary getDefaultHeaderDictionary()
    {
        if(defaultHeaderInstance == null)
        {
            InputStreamReader reader = null;
            try
            {
                reader = new InputStreamReader(
                    DicomDictionary.class.getClassLoader().getResourceAsStream("DicomHeaderDictionary.txt") );
                defaultHeaderInstance = DicomDictionaryReaderImpl.create(reader);
            } 
            catch (IOException e)
            {
                e.printStackTrace();
            }
            finally
            {
                try{reader.close();}catch(Exception x){}
            }
        }
        
        return defaultHeaderInstance;
    }
    
}
