/**
 * 
 */
package gov.va.med.imaging.dicom;

import gov.va.med.imaging.dicom.spi.DicomSPI;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;

/**
 * @author       DNS
 *
 */
public class DicomServiceFactory<S extends DicomSPI>
{
    private final SortedSet<DicomServiceDescription<S>> serviceDescriptions;
    private Map<DicomServiceDescription<S>, S> reentrantSingletons = new HashMap<DicomServiceDescription<S>, S>();
    
    /**
     * 
     * @param serviceDescription
     */
    DicomServiceFactory(SortedSet<DicomServiceDescription<S>> serviceDescriptions)
    {
        this.serviceDescriptions = serviceDescriptions;
    }
    
    /**
     * 
     * @param provider
     * @param version
     * @return
     */
    private DicomServiceDescription<S> getPreferredServiceDescription(String provider, float version)
    {
        for(DicomServiceDescription<S> serviceDescription : this.serviceDescriptions)
            if( provider == null || provider.equals(serviceDescription.getProvider()) ) 
                if( version < 0 || version == serviceDescription.getVersion())
                    return serviceDescription;
        
        return null;
    }
    

    S create() 
    throws DicomServiceCreationException
    {
        return create(null, -1.0f);
    }
    
    /**
     * 
     * @return
     * @throws DicomServiceCreationException 
     */
    @SuppressWarnings("unchecked")
    synchronized S create(String provider, float version) 
    throws DicomServiceCreationException
    {
        S serviceInstance = null;
        try
        {
            DicomServiceDescription<S> serviceDescription = getPreferredServiceDescription(provider, version); 
            S reentrantSingleton = reentrantSingletons.get(serviceDescription);
            if(reentrantSingleton != null)      // is set only if the SPI is marked as reentrant
                return reentrantSingleton;
            

            serviceInstance = (S)serviceDescription.getImplementingClass().newInstance();
            if(serviceDescription.isReentrant())       // save the singleton only if the SPI is marked as reentrant
                this.reentrantSingletons.put(serviceDescription, serviceInstance);
        } 
        catch (InstantiationException e)
        {
            e.printStackTrace();
            throw new DicomServiceCreationException("Unable to create Dicom Service", e);
        } 
        catch (IllegalAccessException e)
        {
            e.printStackTrace();
            throw new DicomServiceCreationException("Unable to create Dicom Service", e);
        }
        
        return serviceInstance;
    }
}
