/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.dicom.importer;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class DicomImporterRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements DicomImporterRouter
 {
	private static DicomImporterRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized DicomImporterRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new DicomImporterRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected DicomImporterRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.OriginIndex> getOriginIndexList(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.OriginIndex.class, 
 				"GetOriginIndexListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetOriginIndexListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.OriginIndex> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.importer.Study getStudyImportStatus(
 			gov.va.med.imaging.exchange.business.dicom.importer.Study study
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.importer.Study> command = (Command<gov.va.med.imaging.exchange.business.dicom.importer.Study>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.importer.Study.class, 
	 				"GetStudyImportStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.importer.Study.class 
		  			},
 					new Object[]{
				 		study
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyImportStatusCommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.importer.Study commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.Order> getOrderListForPatient(
 			gov.va.med.imaging.exchange.business.dicom.importer.OrderFilter orderFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.Order.class, 
 				"GetOrderListForPatientCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.business.dicom.importer.OrderFilter.class 
	  			},
				new Object[]{
			 		orderFilter
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetOrderListForPatientCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.Order> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.OrderingProvider> getOrderingProviderList(
 			java.lang.String siteId
 		 			, java.lang.String searchString
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.OrderingProvider.class, 
 				"GetOrderingProviderListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, java.lang.String.class 
	  			},
				new Object[]{
			 		siteId,searchString
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetOrderingProviderListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.OrderingProvider> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.OrderingLocation> getOrderingLocationList(
 			java.lang.String siteId
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.OrderingLocation.class, 
 				"GetOrderingLocationListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class 
	  			},
				new Object[]{
			 		siteId
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetOrderingLocationListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.OrderingLocation> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.ImagingLocation> getImagingLocationList(
 			java.lang.String siteId
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.ImagingLocation.class, 
 				"GetImagingLocationListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class 
	  			},
				new Object[]{
			 		siteId
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetImagingLocationListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.ImagingLocation> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.StandardReport> getStandardReportList(
 			java.lang.String siteId
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.StandardReport.class, 
 				"GetStandardReportListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class 
	  			},
				new Object[]{
			 		siteId
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetStandardReportListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.StandardReport> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.DiagnosticCode> getDiagnosticCodeList(
 			java.lang.String siteId
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.DiagnosticCode.class, 
 				"GetDiagnosticCodeListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class 
	  			},
				new Object[]{
			 		siteId
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDiagnosticCodeListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.DiagnosticCode> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.Procedure> getProcedureList(
 			java.lang.String siteId
 		 			, java.lang.String imagingLocationIen
 		 			, java.lang.String procedureIen
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.Procedure.class, 
 				"GetProcedureListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, java.lang.String.class, java.lang.String.class 
	  			},
				new Object[]{
			 		siteId,imagingLocationIen,procedureIen
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetProcedureListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.Procedure> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.ProcedureModifier> getProcedureModifierList(
 			java.lang.String siteId
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.ProcedureModifier.class, 
 				"GetProcedureModifierListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class 
	  			},
				new Object[]{
			 		siteId
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetProcedureModifierListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.ProcedureModifier> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.importer.Report getImporterReport(
 			gov.va.med.imaging.exchange.business.dicom.importer.ReportParameters reportParameters
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.importer.Report> command = (Command<gov.va.med.imaging.exchange.business.dicom.importer.Report>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.importer.Report.class, 
	 				"GetImporterReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.importer.ReportParameters.class 
		  			},
 					new Object[]{
				 		reportParameters
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImporterReportCommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.importer.Report commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getImporterVersionCompatible(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetImporterVersionCompatibleCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImporterVersionCompatibleCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.UIDActionConfig> getDgwUIDActionTable(
 			java.lang.String type
 		 			, java.lang.String subType
 		 			, java.lang.String action
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.UIDActionConfig.class, 
 				"GetDgwUIDActionTableCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, java.lang.String.class, java.lang.String.class 
	  			},
				new Object[]{
			 		type,subType,action
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDgwUIDActionTableCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.UIDActionConfig> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 }