package gov.va.med.imaging.dicom;

import java.util.regex.Pattern;

import junit.framework.TestCase;

public class TestTransferSyntaxUid extends TestCase
{

	public final void testGetByUid()
	{
		assertTrue(TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.2"));
		assertTrue(TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.1"));
		assertTrue(TransferSyntaxUid.DEFLATED_EXPLICIT_VR_LITTLEENDIAN == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.1.99"));
		assertTrue(TransferSyntaxUid.RAW_IMPLICIT_VR_LITTLEENDIAN == TransferSyntaxUid.getByUid("1.2.840.10008.1.2"));
		assertTrue(TransferSyntaxUid.JPEG_BASELINE == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.50"));
		assertTrue(TransferSyntaxUid.JPEG_EXTENDED == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.51"));
		assertTrue(TransferSyntaxUid.JPEG_LOSSLESS_NON_HIERARCHICAL == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.57"));
		assertTrue(TransferSyntaxUid.JPEG_LOSSLESS_NON_HIERARCHICAL_FIRST_ORDER == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.70"));
		assertTrue(TransferSyntaxUid.JPEG_LS_LOSSLESS == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.80"));
		assertTrue(TransferSyntaxUid.JPEG_LS_NEAR_LOSSLESS == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.81"));
		assertTrue(TransferSyntaxUid.J2K_PART1_REVERSIBLE == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.90"));
		assertTrue(TransferSyntaxUid.J2K_PART1_IRREVERSIBLE == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.91"));
		assertTrue(TransferSyntaxUid.J2K_PART2_REVERSIBLE == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.92"));
		assertTrue(TransferSyntaxUid.J2K_PART2_IRREVERSIBLE == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.93"));
		assertTrue(TransferSyntaxUid.JPIP_REFERENCED == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.94"));
		assertTrue(TransferSyntaxUid.DEFLATED_JPIP_REFERENCED == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.95"));
		assertTrue(TransferSyntaxUid.MPEG == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.4.100"));
		assertTrue(TransferSyntaxUid.LOSSLESS_RLE == TransferSyntaxUid.getByUid("1.2.840.10008.1.2.5"));
		assertTrue(TransferSyntaxUid.PROPRIETARY == TransferSyntaxUid.getByUid("1.2.3.4"));
		assertTrue(TransferSyntaxUid.PROPRIETARY == TransferSyntaxUid.getByUid(""));
	}

	public final void testMakeUnsignedLongFrom2Bytes()
	{
		TransferSyntaxUid transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN;

		byte[] value = new byte[2];
		// in big endian, 0x0201
		value[0] = 0x02;
		value[1] = 0x01;
		assertEquals( 0x0201L, transferSyntax.makeUnsignedLongFrom2Bytes(value) );
		
		assertEquals( 0L, transferSyntax.makeUnsignedLongFrom2Bytes(transferSyntax.make2BytesFromLong(0L)) );
		assertEquals( 8L, transferSyntax.makeUnsignedLongFrom2Bytes(transferSyntax.make2BytesFromLong(8L)) );
		assertEquals( (2^16-1), transferSyntax.makeUnsignedLongFrom2Bytes(transferSyntax.make2BytesFromLong((2^16-1))) );

		transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN;
		
		// in little endian, 0x0102
		value[0] = 0x02;
		value[1] = 0x01;
		assertEquals( 0x0102L, transferSyntax.makeUnsignedLongFrom2Bytes(value) );
		
		assertEquals( 0L, transferSyntax.makeUnsignedLongFrom2Bytes(transferSyntax.make2BytesFromLong(0L)) );
		assertEquals( 8L, transferSyntax.makeUnsignedLongFrom2Bytes(transferSyntax.make2BytesFromLong(8L)) );
		assertEquals( (2^16-1), transferSyntax.makeUnsignedLongFrom2Bytes(transferSyntax.make2BytesFromLong((2^16-1))) );
	}

	public final void testMakeUnsignedIntFrom2Bytes()
	{
		TransferSyntaxUid transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN;
		
		assertEquals( 0, transferSyntax.makeUnsignedIntFrom2Bytes(transferSyntax.make2BytesFromInt(0)) );
		assertEquals( 8, transferSyntax.makeUnsignedIntFrom2Bytes(transferSyntax.make2BytesFromInt(8)) );
		assertEquals( (2^16-1), transferSyntax.makeUnsignedIntFrom2Bytes(transferSyntax.make2BytesFromInt((2^16-1))) );

		transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN;
		
		assertEquals( 0, transferSyntax.makeUnsignedIntFrom2Bytes(transferSyntax.make2BytesFromInt(0)) );
		assertEquals( 8, transferSyntax.makeUnsignedIntFrom2Bytes(transferSyntax.make2BytesFromInt(8)) );
		assertEquals( (2^16-1), transferSyntax.makeUnsignedIntFrom2Bytes(transferSyntax.make2BytesFromInt((2^16-1))) );
	}

	public final void testMakeUnsignedIntFrom4Bytes()
	{
		TransferSyntaxUid transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN;
		
		assertEquals( 0, transferSyntax.makeUnsignedIntFrom4Bytes(transferSyntax.make4BytesFromInt(0)) );
		assertEquals( 8, transferSyntax.makeUnsignedIntFrom4Bytes(transferSyntax.make4BytesFromInt(8)) );
		assertEquals( (2^16-1), transferSyntax.makeUnsignedIntFrom4Bytes(transferSyntax.make4BytesFromInt((2^16-1))) );
		assertEquals( (2^24-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^24-1))) );
		assertEquals( (2^32-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^32-1))) );

		transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN;
		
		assertEquals( 0, transferSyntax.makeUnsignedIntFrom4Bytes(transferSyntax.make4BytesFromInt(0)) );
		assertEquals( 8, transferSyntax.makeUnsignedIntFrom4Bytes(transferSyntax.make4BytesFromInt(8)) );
		assertEquals( (2^16-1), transferSyntax.makeUnsignedIntFrom4Bytes(transferSyntax.make4BytesFromInt((2^16-1))) );
		assertEquals( (2^24-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^24-1))) );
		assertEquals( (2^32-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^32-1))) );
	}

	public final void testMakeUnsignedLongFrom4Bytes()
	{
		TransferSyntaxUid transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN;
		
		assertEquals( 0, transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong(0)) );
		assertEquals( 8, transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong(8)) );
		assertEquals( (2^16-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^16-1))) );
		assertEquals( (2^24-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^24-1))) );
		assertEquals( (2^32-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^32-1))) );

		transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN;
		
		assertEquals( 0, transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong(0)) );
		assertEquals( 8, transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong(8)) );
		assertEquals( (2^16-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^16-1))) );
		assertEquals( (2^24-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^24-1))) );
		assertEquals( (2^32-1), transferSyntax.makeUnsignedLongFrom4Bytes(transferSyntax.make4BytesFromLong((2^32-1))) );
	}
}
