/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Jul 31, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.exceptions;

/**
 * @author DNS
 * 
 * An exception that is thrown when a SQ element or one of its children does not meet the
 * specification.  Usually this means that an element tag was not in the expected sequence.
 */
public class DicomFormatSequenceException 
extends DicomFormatException
{
	private static final long serialVersionUID = -3836181085353362699L;

	/**
	 * 
	 */
	public DicomFormatSequenceException()
	{
	}

	/**
	 * @param message
	 */
	public DicomFormatSequenceException(String message)
	{
		super(message);
	}

	/**
	 * @param cause
	 */
	public DicomFormatSequenceException(Throwable cause)
	{
		super(cause);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public DicomFormatSequenceException(String message, Throwable cause)
	{
		super(message, cause);
	}

}
