/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Jul 17, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dictionary;

import java.io.Serializable;
import java.util.Arrays;

import gov.va.med.imaging.dicom.ValueRepresentation;

/**
 * @author      DNS
 *
 */
public class DicomDictionaryEntry
implements Serializable
{
	private static final long serialVersionUID = -4837094920693872211L;
	
	private final int groupStart;
	private final int groupEnd;
	private final int elementStart;
	private final int elementEnd;
	private final String description;
	private final int minMultiplicity; 
	private final int maxMultiplicity; 
	private final boolean retired;
	private final ValueRepresentation[] vr;
	
	DicomDictionaryEntry(
		int groupStart, 
		int groupEnd, 
		int elementStart, 
		int elementEnd, 
		String description,
		int minMultiplicity, 
		int maxMultiplicity,
		boolean retired,
		ValueRepresentation... vr) 
	{
		this.groupStart = groupStart;
		this.groupEnd = groupEnd;
		this.elementStart = elementStart;
		this.elementEnd = elementEnd;
		this.description = description;
		this.minMultiplicity = minMultiplicity; 
		this.maxMultiplicity = maxMultiplicity; 
		this.retired = retired;
		this.vr = vr;
	}

	/**
     * @return the groupStart
     */
    public int getGroupStart()
    {
    	return groupStart;
    }



	/**
     * @return the groupEnd
     */
    public int getGroupEnd()
    {
    	return groupEnd;
    }



	/**
     * @return the elementStart
     */
    public int getElementStart()
    {
    	return elementStart;
    }



	/**
     * @return the elementEnd
     */
    public int getElementEnd()
    {
    	return elementEnd;
    }



	/**
     * @return the description
     */
    public String getDescription()
    {
    	return description;
    }

	/**
     * @return the vr
     */
    public ValueRepresentation[] getVr()
    {
    	return vr;
    }

	/**
     * @return the minMultiplicity
     */
    public int getMinMultiplicity()
    {
    	return minMultiplicity;
    }

	/**
     * @return the maxMultiplicity
     */
    public int getMaxMultiplicity()
    {
    	return maxMultiplicity;
    }

	/**
     * @return the retired
     */
    public boolean isRetired()
    {
    	return retired;
    }

	/**
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode()
    {
	    final int prime = 31;
	    int result = 1;
	    result = prime * result + ((description == null) ? 0 : description.hashCode());
	    result = prime * result + elementEnd;
	    result = prime * result + elementStart;
	    result = prime * result + groupEnd;
	    result = prime * result + groupStart;
	    result = prime * result + maxMultiplicity;
	    result = prime * result + minMultiplicity;
	    result = prime * result + (retired ? 1231 : 1237);
	    result = prime * result + Arrays.hashCode(vr);
	    return result;
    }

	/**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj)
    {
	    if (this == obj)
		    return true;
	    if (obj == null)
		    return false;
	    if (getClass() != obj.getClass())
		    return false;
	    final DicomDictionaryEntry other = (DicomDictionaryEntry) obj;
	    if (description == null)
	    {
		    if (other.description != null)
			    return false;
	    } else if (!description.equals(other.description))
		    return false;
	    if (elementEnd != other.elementEnd)
		    return false;
	    if (elementStart != other.elementStart)
		    return false;
	    if (groupEnd != other.groupEnd)
		    return false;
	    if (groupStart != other.groupStart)
		    return false;
	    if (maxMultiplicity != other.maxMultiplicity)
		    return false;
	    if (minMultiplicity != other.minMultiplicity)
		    return false;
	    if (retired != other.retired)
		    return false;
	    if (!Arrays.equals(vr, other.vr))
		    return false;
	    return true;
    }
    
    @Override
    public String toString()
    {
    	return "0x" + groupStart + "-" + "0x" + groupEnd + ":" +
    		"0x" + elementStart + "-" + "0x" + elementEnd + " " +  
    		"'" + description + "' " + 
    		minMultiplicity + " to " + maxMultiplicity + " instances" + " " + 
    		(retired ? "RETIRED" : "NOT RETIRED") + " " +
    		vr[0].getName();
    }
    
}
