/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 14, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.RawPixelInterpretationValuesNotSetException;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.List;

/**
 * @author DNS
 *
 */
public abstract class NativePixelDataElement
extends DataElement<byte[]>
{
	public NativePixelDataElement(DataElementFactory instantiatingFactory, DataElementTag dataElementTag,
            DicomDictionaryEntry dictionaryEntry, long valueLength, byte[] value) throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
    }

	public NativePixelDataElement(DataElementFactory instantiatingFactory, DataElementTag dataElementTag,
            ValueRepresentation explicitVRField, long valueLength, byte[] value) throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
    }

	/**
	 * The DataSet should call this method, supplying the following three element values.
	 * (0028,0100) Bits Allocate
	 * (0028,0101) Bits Store
	 * (0028,0102) High Bit
	 * 
	 * DataElements do not, intrinsically, have visibility of other data elements, so these values must
	 * be passed into here. 
	 * 
	 * NOTE: if this method is not called before calling getRawPixelData().  If not then a
	 * RawPixelInterpretationValuesNotSetException will be thrown.
	 * 
	 * @param bitsAllocated
	 * @param bitStored
	 * @param highBit
	 * @return
	 * @throws DicomFormatException 
	 */
	public abstract void setNativePixelInterpretationParameters(
			int bitsAllocated, 
			int bitStored, 
			int highBit,
    		int width,
    		int height) 
	throws DicomFormatException;
	
	/**
	 * setRawPixelInterpretationParameters must be called before calling getRawPixelData().  If not then a
	 * RawPixelInterpretationValuesNotSetException will be thrown.
	 * 
	 * @return
	 * @throws DicomFormatException
	 * @throws RawPixelInterpretationValuesNotSetException when setRawPixelInterpretationParameters has not been called
	 */
	public abstract List<BufferedImage> getNativePixelData() 
	throws DicomFormatException, RawPixelInterpretationValuesNotSetException;

	/**
	 * The word size that the derived class operates on.  
	 * Currently either 8 (OB elements) or 16 (OW elements).
	 * @return
	 */
	protected abstract int getWordSize();
	
	protected static ColorModel createColorModel(int colorSpaceType, int wordSize)
    {
	    ColorSpace cs = ColorSpace.getInstance(ColorSpace.CS_GRAY);

    	return new ColorModel(wordSize)
    	{
    		@Override
            public boolean isCompatibleRaster(Raster raster)
            {
    			return (raster.getDataBuffer().getDataType() == DataBuffer.TYPE_INT);
            }
    
    		@Override
            public ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied)
            {
                return this;
            }
    
    		@Override
            public int getAlpha(int pixel)
            {
                return 0xFF;
            }
    
    		@Override
            public int getBlue(int pixel)
            {
                return (byte)(pixel >> (this.pixel_bits - 8));
            }
    
    		@Override
            public int getGreen(int pixel)
            {
                return (byte)(pixel >> (this.pixel_bits - 8));
            }
    
    		@Override
            public int getRed(int pixel)
            {
                return (byte)(pixel >> (this.pixel_bits - 8));
            }
    	};
    
    }
}
