/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 11, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomDateFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * @author DNS
 *
 * A string of characters of the format hhmmss.frac; where hh contains hours (range '00' - '23'), 
 * mm contains minutes (range '00' - '59'), ss contains seconds (range '00' - '59'), and frac 
 * contains a fractional part of a second as small as 1 millionth of a second (range '000000' - '999999'). 
 * A 24 hour clock is assumed. Midnight can be represented by only '0000' since '2400' would violate 
 * the hour range. The string may be padded with trailing spaces. Leading and embedded spaces are not 
 * allowed. One or more of the components mm, ss, or frac may be unspecified as long as every component to 
 * the right of an unspecified component is also unspecified. If frac is unspecified the preceding '.' 
 * may not be included. Frac shall be held to six decimal places or less to ensure its format conforms to 
 * the ANSI HISPP MSDS Time common data type.
 * 
 * '0'-'9', '.' of Default Character Repertoire

 */
public class DataElement_TM 
extends DataElement<Long>
{
	private static Pattern timePattern = Pattern.compile( 	"([\\d]{2})([\\d]{2})?([\\d]{2})?(\\x2e[\\d]{1,6})?");
	private Long value = null;


	public DataElement_TM(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, DicomDictionaryEntry dictionaryEntry,
            long valueLength, byte[] value) throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
    }

	public DataElement_TM(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, ValueRepresentation explicitVRField,
            long valueLength, byte[] value) throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
    }

	/**
     * @throws DicomDateFormatException 
	 * @throws DicomDateFormatException
     */
	@Override
    protected void parseRawValue() 
	throws DicomDateFormatException 
    {
		if(getRawValue() == null || getRawValue().length == 0)
			value = new Long(0L);
		else
		{
			String rawValueAsString = new String(getRawValue());
			Matcher patternMatcher = DataElement_TM.timePattern.matcher(rawValueAsString);
			if(! patternMatcher.matches() )
				throw new DicomDateFormatException("The value '" + rawValueAsString + "' is not a valid DICOM TM element.");
			String hours = patternMatcher.group(1);
			String minutes = patternMatcher.groupCount() > 2 ? patternMatcher.group(2) : "0";
			String seconds = patternMatcher.groupCount() > 3 ? patternMatcher.group(3) : "0";
			String subseconds = patternMatcher.groupCount() > 4 ? patternMatcher.group(4) : ".0000";
	
			long tmpValue;
	        try
	        {
		        tmpValue = (Integer.parseInt(hours) * 60l * 60l * 1000l);
		        tmpValue += (Integer.parseInt(minutes) * 60l * 1000l);
		        tmpValue += (Integer.parseInt(seconds) * 1000l);
		        tmpValue += Integer.parseInt(subseconds.substring(1));
	        } 
	        catch (NumberFormatException e)
	        {
				throw new DicomDateFormatException("The value '" + rawValueAsString + "' is not a valid DICOM TM element, it contains non-numeric characters.");
	        }
			
			value = new Long(tmpValue);
		}
    }

	@Override
    public Long getValue() 
	throws ValueRepresentationInterpretationException
    {
	    return value;
    }

}
