package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;

/**
 * A generic abstract class for VR's that interpret the byte stream as String data.
 * 
 * @author       DNS
 *
 */
public abstract class DataElement_String 
extends DataElement<String>
{

	private String value = null;

	public DataElement_String(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, ValueRepresentation explicitVRField,
	        long valueLength, byte[] value) throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	public DataElement_String(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, DicomDictionaryEntry dictionaryEntry,
	        long valueLength, byte[] value) throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}

	/**
     * 
     * @see gov.va.med.imaging.dicom.DataElement#getValue()
     */
    @Override
    public String getValue()
    {
    	return value;
    }

	@Override
    protected void parseRawValue() throws DicomFormatException
    {
    	if(getRawValue() == null)
    		value = "";
    	else
            value = new String(getRawValue());
    }

}