/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 11, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

/**
 * @author DNS
 * Signed binary integer 16 bits long in 2's complement form. 
 * Represents an integer, n, in the range: -2^15 <= n <= (2^15 - 1).",
 */
public class DataElement_SS 
extends DataElement<Integer>
{

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param explicitVRField
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException
	 */
	public DataElement_SS(
			DataElementFactory instantiatingFactory, 
			DataElementTag dataElementTag, 
			ValueRepresentation explicitVRField,
	        long valueLength, byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param dictionaryEntry
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException
	 */
	public DataElement_SS(
			DataElementFactory instantiatingFactory, 
			DataElementTag dataElementTag, 
			DicomDictionaryEntry dictionaryEntry,
	        long valueLength, byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}

	private Integer value;
	
	/**
	 * @see gov.va.med.imaging.dicom.DataElement#getValue()
	 */
	@Override
	public Integer getValue() 
	throws ValueRepresentationInterpretationException
	{
		return value;
	}

	/**
	 * @see gov.va.med.imaging.dicom.DataElement#parseRawValue()
	 */
	@Override
	protected void parseRawValue() 
	throws DicomFormatException
	{
		value = new Integer( this.getInstantiatingFactory().getTransferSyntaxUid().makeUnsignedIntFrom2Bytes(getRawValue()) );
	}

}
