/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 11, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.DataSet;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.IncompatibleValueLengthField;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;
import gov.va.med.imaging.dicom.io.DataElementLimitedInputStream;
import gov.va.med.imaging.dicom.io.DataElementReader;
import gov.va.med.imaging.dicom.io.DataSetReader;

/**
 * @author DNS
 *
 */
public class DataElement_SQ 
extends DataElement<List<DataSet>>
{

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param explicitVRField
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException
	 */
	public DataElement_SQ(
			DataElementFactory instantiatingFactory, 
			DataElementTag dataElementTag, 
			ValueRepresentation explicitVRField,
	        long valueLength, byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param dictionaryEntry
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException
	 */
	public DataElement_SQ(
			DataElementFactory instantiatingFactory, 
			DataElementTag dataElementTag, 
			DicomDictionaryEntry dictionaryEntry,
	        long valueLength, 
	        byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}

	private List<DataSet> value = null;
	/**
	 * @see gov.va.med.imaging.dicom.DataElement#getValue()
	 */
	@Override
	public List<DataSet> getValue() 
	throws ValueRepresentationInterpretationException
	{
		return value;
	}

	/**
	 * @see gov.va.med.imaging.dicom.DataElement#parseRawValue()
	 */
	@Override
	protected void parseRawValue() 
	throws DicomFormatException
	{
		DataInputStream inStream = new DataInputStream( new ByteArrayInputStream(getRawValue()) ); 
		parseInputStream(inStream);
	}

	/**
	 */
	protected void parseInputStream(DataInputStream inStream)
	{
		DataElementLimitedInputStream dataElementInputStream = 
			new DataElementLimitedInputStream( inStream, getInstantiatingFactory().getTransferSyntaxUid() );
		DataElementReader reader = new DataElementReader(dataElementInputStream, getInstantiatingFactory());
		try
        {
	        DataElement<?> element = reader.readNextDataElement();
	        DataSetReader childSetReader = new DataSetReader(dataElementInputStream, getInstantiatingFactory());
	        childSetReader.readDataSet();
        } 
		catch (IOException e)
        {
	        e.printStackTrace();
        } 
		catch (InvalidVRModeException e)
        {
	        e.printStackTrace();
        } 
		catch (InvalidVRException e)
        {
	        e.printStackTrace();
        } 
		catch (IncompatibleValueLengthField e)
        {
	        e.printStackTrace();
        } 
		catch (DicomFormatException e)
        {
	        e.printStackTrace();
        }
	}
}
