package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;

/**
 * A character string that may be padded with leading and/or trailing spaces. 
 * The character code 05CH (the BACKSLASH '\' in ISO-IR 6) shall not be present, 
 * as it is used as the delimiter between values for multiple data elements. 
 * The string shall not have Control Characters except ESC.
 * 
 * @author       DNS
 *
 */
public class DataElement_SH 
extends DataElement_String
{

	public DataElement_SH(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, DicomDictionaryEntry dictionaryEntry,
            long valueLength, byte[] value) throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
    }

	public DataElement_SH(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, ValueRepresentation explicitVRField,
            long valueLength, byte[] value) throws DicomFormatException
    {
	    super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
    }

}
