/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 7, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;

/**
 * @author DNS
 *
 * A character string encoded using a 5 component convention. 
 * The character code 5CH (the BACKSLASH '\' in ISO-IR 6) shall not be present, 
 * as it is used as the delimiter between values in multiple valued data elements. 
 * The string may be padded with trailing spaces. For human use, the five components in 
 * their order of occurrence are: family name complex, given name complex, middle name, 
 * name prefix, name suffix. Any of the five components may be an empty string. 
 * The component delimiter shall be the caret ^ character (5EH). Delimiters are required for 
 * interior null components. Trailing null components and their delimiters may be omitted. 
 * Multiple entries are permitted in each component and are encoded as natural text strings, 
 * in the format preferred by the named person. This conforms to the ANSI HISPP MSDS Person Name common data type.
 * For veterinary use, the first two of the five components in their order of occurrence are: 
 * responsible party family name or responsible organization name, patient name. The remaining components are not 
 * used and shall not be present.
 * This group of five components is referred to as a Person Name component group.  For the purpose of writing 
 * names in ideographic characters and in phonetic characters, up to 3 groups of components 
 * (see Annex H examples 1 and 2) may be used. The delimiter for component groups shall be the equals 
 * character = (3DH). The three component groups of components in their order of occurrence are: a 
 * single-byte character representation, an ideographic representation, and a phonetic representation.
 * Any component group may be absent, including the first component group. In this case, the person name may 
 * start with one or more = delimiters. Delimiters are required for interior null component groups. 
 * Trailing null component groups and their delimiters may be omitted.
 * Precise semantics are defined for each component group. See section 6.2.1.
 * 
 * Default Character Repertoire and/or as defined by (0008,0005) excluding Control Characters LF, FF, and CR but 
 * allowing Control Character ESC.
 * 
 * Default Character Repertoire and/or as defined by (0008,0005).
 */
public class DataElement_PN 
extends DataElement_String
{
	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param explicitVRField
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException 
	 */
	public DataElement_PN(
		DataElementFactory instantiatingFactory, 
		DataElementTag dataElementTag, 
		ValueRepresentation explicitVRField,
        long valueLength, 
        byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param dictionaryEntry
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException 
	 */
	public DataElement_PN(
		DataElementFactory instantiatingFactory, 
		DataElementTag dataElementTag, 
		DicomDictionaryEntry dictionaryEntry,
	    long valueLength, 
	    byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}
}
