package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;

/**
 * An 'identity' value representation where the raw value is the same as the interpreted
 * value.
 * 
 * @author       DNS
 *
 */
public abstract class DataElement_Identity 
extends DataElement<byte[]>
{

	public DataElement_Identity(DataElementFactory instantiatingFactory, DataElementTag dataElementTag,
	        ValueRepresentation explicitVRField, long valueLength, byte[] value) throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	public DataElement_Identity(DataElementFactory instantiatingFactory, DataElementTag dataElementTag,
	        DicomDictionaryEntry dictionaryEntry, long valueLength, byte[] value) throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}

	/**
     * 
     * @see gov.va.med.imaging.dicom.DataElement#getValue()
     */
    @Override
    public byte[] getValue()
    {
    	return getRawValue();
    }

	@Override
    protected void parseRawValue() 
	throws DicomFormatException
    {
    	// does nothing
    }

}