/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 7, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException_IS;

/**
 * @author DNS
 *
 * A string of characters representing an Integer in base-10 (decimal), shall contain only the 
 * characters 0 - 9, with an optional leading '+' or '-'. It may be padded with leading and/or 
 * trailing spaces. Embedded spaces are not allowed.
 * 
 * range: -2^31 <= n <= (2^31 - 1)
 * 
 */
public class DataElement_IS 
extends DataElement<Integer>
{
	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param explicitVRField
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException 
	 */
	public DataElement_IS(
		DataElementFactory instantiatingFactory, 
		DataElementTag dataElementTag, 
		ValueRepresentation explicitVRField,
        long valueLength, 
        byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param dictionaryEntry
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException 
	 */
	public DataElement_IS(
		DataElementFactory instantiatingFactory, 
		DataElementTag dataElementTag, 
		DicomDictionaryEntry dictionaryEntry,
	    long valueLength, 
	    byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}

	private Integer value = null;
	
	/**
	 * 
	 * @see gov.va.med.imaging.dicom.DataElement#getValue()
	 */
	@Override
	public Integer getValue()
	{
		return value;
	}

	@Override
    protected void parseRawValue() 
	throws DicomFormatException
    {
		if(getRawValue() == null)
			value = new Integer(0);
		else
		{
	        String tmp = new String(getRawValue());
	        tmp = tmp.trim();
			try
	        {
		        value = Integer.parseInt(tmp);
	        } 
			catch (NumberFormatException e)
	        {
				throw new DicomFormatException_IS(tmp);
	        }
		}
    }
}
